#!/bin/bash
#
# @(#) writes a quick makefile for remaking the executable in the current 
# @(#) directory
#
if [ $# -lt 1 ]; then
   echo "Usage: $0 nD [setup_blah.f90]";
else
   echo '#'
   echo '#--Makefile to remake the executable and copy to this directory'
   echo '#  Generated by '$0':' `date`
   echo '#'
   echo '#NDSPMHD_DIR='${0/scripts\/writemake.sh/};
   if [ $# -ge 2 ]; then
      echo 'export SETUP1D='$2;   
      echo 'export SETUP2D='$2;   
      echo 'export SETUP3D='$2;   
   fi
   echo ''
   echo default':'$1
   echo ''
   echo '3D: checkdir'
   echo '	cd ${NDSPMHD_DIR}; make 3D; cd -; cp ${NDSPMHD_DIR}/3DSPMHD .'
   echo '2D: checkdir'
   echo '	cd ${NDSPMHD_DIR}; make 2D; cd -; cp ${NDSPMHD_DIR}/2DSPMHD .'
   echo '1D: checkdir'
   echo '	cd ${NDSPMHD_DIR}; make 1D; cd -; cp ${NDSPMHD_DIR}/1DSPMHD .'
   echo 'edit: checkdir checkeditor'
   echo '	cd ${NDSPMHD_DIR}; make edit'$1
   echo 'moddump: checkdir'
   echo '	cd ${NDSPMHD_DIR}/src; make moddump'$1
   echo 'moddumpc: checkdir'
   echo '	cd ${NDSPMHD_DIR}/src; make clean; make moddump'$1
   echo 'make: checkdir checkeditor'
   echo '	cd ${NDSPMHD_DIR}/src; $(EDITOR) Makefile &'
   echo 'clean: checkdir'
   echo '	cd ${NDSPMHD_DIR}; make clean'
   echo 'cleanfiles:'
   echo '	rm *.ev *_0*.dat version'
   echo 'cleanallfiles:'
   echo '	rm *.ev *_0*.dat version ?DSPMHD'
   echo 'checkdir:'
   echo '   ifndef NDSPMHD_DIR'
   echo '	@echo'
   echo '	@echo "ERROR: need NDSPMHD_DIR set to location of ndspmhd code"'
   echo '	@echo "       e.g. export NDSPMHD_DIR=~/ndspmhd"'
   echo '	@echo'
   echo '	@quit'
   echo '   endif'
   echo 'checkeditor:'
   echo '   ifndef EDITOR'
   echo '	@echo'
   echo '	@echo "ERROR: need EDITOR variable set for this option (e.g. export EDITOR=emacs)"'
   echo '	@echo'
   echo '	@quit'
   echo '   endif'
 fi
