!------------------------------------------------------------------------------!
! NDSPMHD: A Smoothed Particle (Magneto)Hydrodynamics code for (astrophysical) !
! fluid dynamics simulations in 1, 2 and 3 spatial dimensions.                 !
!                                                                              !
! (c) 2002-2014 Daniel Price                                                   !
!                                                                              !
! http://users.monash.edu.au/~dprice/ndspmhd                                   !
! daniel.price@monash.edu -or- dprice@cantab.net (forwards to current address) !
!                                                                              !
!  NDSPMHD comes with ABSOLUTELY NO WARRANTY.                                  !
!  This is free software; and you are welcome to redistribute                  !
!  it under the terms of the GNU General Public License                        !
!  (see LICENSE file for details) and the provision that                       !
!  this notice remains intact. If you modify this file, please                 !
!  note section 2a) of the GPLv2 states that:                                  !
!                                                                              !
!  a) You must cause the modified files to carry prominent notices             !
!     stating that you changed the files and the date of any change.           !
!                                                                              !
!  ChangeLog:                                                                  !
!------------------------------------------------------------------------------!

!--------------------------------------------------------------
! global parameters for NDSPMHD
! this specifies the number of spatial & velocity dimensions
!--------------------------------------------------------------

MODULE dimen_mhd
 IMPLICIT NONE
 INTEGER, PARAMETER :: ndim = 3         ! Dimensions
 INTEGER, PARAMETER :: ndimB = 3        ! Dimensions of Magnetic field variable
 INTEGER, PARAMETER :: ndimV = ndimB    ! Dimensions of Velocity variable
 INTEGER :: idim    ! size of allocated arrays
 REAL :: dndim      ! for divisions by ndim (set in initialise)
END MODULE
