/*************************************************************************/
/*									 */
/*	Get case descriptions from data file				 */
/*	--------------------------------------				 */
/*									 */
/*************************************************************************/


#include "defns.h"
#include "types.h"
#include "extern.h"
#include <time.h>


#define Inc 2048



/*************************************************************************/
/*									                                     */
/*  Read raw training data descriptions from file with given extension.	 */
/*									                                     */
/*									                                     */
/*************************************************************************/

    GetData(Extension)
/*  --------  */
    String Extension;
{
    FILE *Df, *fopen();
    char Fn[100];
    ItemNo i=0, j,k, ItemSpace=0;
    Description GetDescription();

    /*  Open data file  */

    strcpy(Fn, FileName);
    strcat(Fn, Extension);
    if ( ! ( Df = fopen(Fn, "r") ) ) Error(0, Fn, "");

    do
    {
    	UnSampleMaxItem = i;

	if ( i >= ItemSpace )
	{
	    if ( ItemSpace )
	    {
		ItemSpace += Inc;
		UnSampleItem = (Description *)
			realloc(UnSampleItem, ItemSpace*sizeof(Description));
	    }
	    else
	    {
	    	UnSampleItem = (Description *)
			malloc((ItemSpace=Inc)*sizeof(Description));
	    }
	}


	UnSampleItem[i] = GetDescription(Df);


    } while ( UnSampleItem[i] != Nil && ++i );


    fclose(Df);

    UnSampleMaxItem = i - 1;

}



/*************************************************************************/
/*									                                     */
/*  Read raw testing data descriptions from file with given extension.	 */
/*									                                     */
/*									                                     */
/*************************************************************************/
    GetTestData(Extension)
/*  --------  */
    String Extension;
{
    FILE *Df, *fopen();
    char Fn[100];
    ItemNo i=0, j,k, ItemSpace=0;
    Description GetDescription();

    /*  Open data file  */

    strcpy(Fn, FileName);
    strcat(Fn, Extension);
    if ( ! ( Df = fopen(Fn, "r") ) ) Error(0, Fn, "");

    do
    {
    	TDMaxItem = i;

	if ( i >= ItemSpace )
	{
	    if ( ItemSpace )
	    {
		ItemSpace += Inc;
		TDItem = (Description *)
			realloc(TDItem, ItemSpace*sizeof(Description));
	    }
	    else
	    {
	    	TDItem = (Description *)
			malloc((ItemSpace=Inc)*sizeof(Description));
	    }
	}


	TDItem[i] = GetDescription(Df);


    } while ( TDItem[i] != Nil && ++i );


    fclose(Df);
    TDMaxItem = i - 1;

}



/*************************************************************************/
/*									                                     */
/*  Read a raw case description from file Df.			              	 */
/*									                                     */
/*  For each attribute, read the attribute value from the file.		     */
/*  If it is a discrete valued attribute, find the associated no.	     */
/*  of this attribute value (if the value is unknown this is 0).	     */
/*									                                     */
/*  Returns the Description of the case (i.e. the array of		         */
/*  attribute values).							                         */
/*									                                     */
/*************************************************************************/


Description GetDescription(Df)
/*          ---------------  */
    FILE *Df;
{
    Attribute Att;
    char name[500], *endname, *CopyString();
    Boolean ReadName();
    long Dv;
    float Cv;
    Description Dvec;
    double strtod();

    if ( ReadName(Df, name) )
    {
		Dvec = (Description) calloc(UnSampleMaxAtt+2, sizeof(AttValue));

        ForEach(Att, 0, UnSampleMaxAtt)
        {
	    if ( UnSampleSpecialStatus[Att] == IGNORE )
	    {
		UnSampleDVal(Dvec, Att) = 0;
	    }
	    else
	    if ( UnSampleMaxAttVal[Att] || UnSampleSpecialStatus[Att] == DISCRETE )
	    {
	        if ( ! ( strcmp(name, "?") ) )
			{
		    Dv = 0;
			}
	        else
	        {
		    Dv = Which(name, UnSampleAttValName[Att], 1, UnSampleMaxAttVal[Att]);
		    if ( ! Dv )
		    {
			if ( UnSampleSpecialStatus[Att] == DISCRETE )
			{
			    Dv = ++UnSampleMaxAttVal[Att];
			    if ( Dv > (long) UnSampleAttValName[Att][0] )
			    {
				printf("\nToo many values for %s (max %d)\n",
						UnSampleAttName[Att], (long) UnSampleAttValName[Att][0]);
				exit(1);
			    }

			    UnSampleAttValName[Att][Dv] = CopyString(name);
			}
			else
			{
			    Error(4, UnSampleAttName[Att], name);
			}
		    }
	        }
	        UnSampleDVal(Dvec, Att) = Dv;

	    }
	    else
	    {
		/*  Continuous value  */

	        if ( ! ( strcmp(name, "?") ) )
		{
		    Cv = Unknown;
		}
	        else
		{
		    Cv = strtod(name, &endname);
		    if ( endname == name || *endname != '\0' )
			Error(4, UnSampleAttName[Att], name);
		}
		UnSampleCVal(Dvec, Att) = Cv;

	    }

	    ReadName(Df, name);
        }


        if ( (Dv = Which(name, ClassName, 0, MaxClass)) < 0 )
        {
	    Error(5, "", name);
	    Dv = 0;
        }

	UnSampleClass(Dvec) = Dv;

	return Dvec;
    }
    else
    {
	 return Nil;
    }


}


/*************************************************************************/
/*									                                     */
/*   regain data, Put data into array of Item   		              	 */
/*									                                     */
/*									                                     */
/*************************************************************************/

GetMatrixData()
{
	ItemNo i=0, j, k,ItemSpace=0;
    Description GetSampleDescription();

    MaxItem = UnSampleMaxItem;

 	for(i=0;i<=MaxItem;++i)
 	{

 		if ( i >= ItemSpace )
 		{
 		    if ( ItemSpace )
 		    {
 			ItemSpace += Inc;
 			Item = (Description *)
 				realloc(Item, ItemSpace*sizeof(Description));
 		    }
 		    else
 		    {
 			Item = (Description *)
 				malloc((ItemSpace=Inc)*sizeof(Description));
 		    }
 		}

 		Item[i] = GetSampleDescription(i);

 	}

}



/*************************************************************************/
/*									                                     */
/*   Sampling training data for building tree with replacement.        	 */
/*									                                     */
/*************************************************************************/

    GetSampleData()
{
    ItemNo i=0, j, k,ItemSpace=0;  
    long *b;
	long result;
	long OOBNumber;

    Description GetSampleDescription();

   	printf("\n*****random Seed=%d\n",randomSeed);
    srand(randomSeed+rand());
    randomSeed++;	


	MaxItem = UnSampleMaxItem;


    b = (long *) calloc(MaxItem+1, sizeof(long));

    for (k=0;k<=MaxItem;++k)
 	{
 		b[k] = rand() % (UnSampleMaxItem+1);

 	}
	
	OOBNumber = 0;
	result=1;
    for (k=0;k<=UnSampleMaxItem;++k)
	{

    	for(i=0;i<=MaxItem;++i)
		{
    		if(b[i]==k)
    		{
    			result=0;
    			break;
    		}
		}
		if(result)
		{
			OOBData[OOBNumber]= k;
			OOBNumber++;
		}
		else
			result=1;
	}
	OOBDataLength=OOBNumber-1;


 	for(i=0;i<=MaxItem;++i)
 	{

 		if ( i >= ItemSpace )
 		{
 		    if ( ItemSpace )
 		    {
 			ItemSpace += Inc;
 			Item = (Description *)
 				realloc(Item, ItemSpace*sizeof(Description));
 		    }
 		    else
 		    {
 			Item = (Description *)
 				malloc((ItemSpace=Inc)*sizeof(Description));
 		    }
 		}

 		Item[i] = GetSampleDescription(b[i]);

 	}


	free(b);
	b = NULL;

}





long dfi;

Description GetSampleDescription(dfi)
{
	Attribute Att;
    Description SampleDvec = NULL;
    long Dv;
    float Cv = 0.0000;


	if( SampleDvec!= NULL)
	{
		free(SampleDvec);
		SampleDvec=NULL; 
	}

    SampleDvec = (Description) calloc(MaxAtt+2, sizeof(AttValue));

    ForEach(Att,0,MaxAtt)
    {

	    if ( UnSampleSpecialStatus[Att] == IGNORE )//****
	    {
		    DVal(SampleDvec, Att) = 0;
	    }
	    else
	    if ( UnSampleMaxAttVal[Att] || UnSampleSpecialStatus[Att] == DISCRETE )
    	{
    	    Dv = UnSampleDVal(UnSampleItem[dfi],Att);
    		DVal(SampleDvec,Att)=Dv;
    	}
    	else
    	{
    	    Cv = UnSampleCVal(UnSampleItem[dfi],Att);    		
			CVal(SampleDvec, Att)= Cv;
    	}

    }
	Class(SampleDvec) = UnSampleClass(UnSampleItem[dfi]);

	return SampleDvec;

}


