
/**
 * Main routine, Testing Informativeness.
 * Output proportion of informative features.
 *
 * @author Baoxun Xu (Programmer)
 * @version $Revision: 1.0 $
 */





#include <stdlib.h>
#include "defns.h"
#include "types.h"



/*  The definition of global variables  */

long	MaxAtt, MaxClass, MaxDiscrVal = 2;


ItemNo		MaxItem;

Description	*Item= NULL;

DiscrValue	*MaxAttVal= NULL;

char		*SpecialStatus= NULL;


String	*ClassName=NULL,//ClassName
		*AttName= NULL,
		**AttValName,
		FileName = "DF";



//////Output file definition//////
FILE *Pn;
char outFile[100];
//////////////////////////////////

long	VERBOSITY = 0;

//statistic Method:1.Chisqure,2,Information Gain
short   statisticMethod =1;

float   InfoThres = 0.0001;


float	*AttributeFreq=NULL;
float	SumAttributeFreq, SumHighWeightAttFreq;
long	*HighWeightAtt=NULL;


float *AttrFreqPercent=NULL;
float *AttributeInfro = NULL;


Boolean		GAINRATIO  = true,
		SUBSET     = false,
		UNSEENS    = false,
		PROBTHRESH = false;

ItemNo		MINOBJS   = 2;

Boolean		AllKnown = true;


    main(Argc, Argv)
/*  ----  */
    int Argc;
    char *Argv[];
{
    long o;
    long i,j,s,y,t,ii;

    extern char *optarg;
    extern int optind;
    Boolean FirstTime=true;
	float ChiQuareInfroValue(),InfoGainInfroValue();

	PrintHeader("Proportion of informative features:");

    /*  Process options  */

	while ( (o = getopt(Argc, Argv, "f:i:s:")) != EOF )
    {
	if ( FirstTime )
	{
	    printf("\n    Options:\n");
	    FirstTime = false;
	}

	switch (o)
	{
	case 'f':   FileName = optarg;
		    printf("\tFile stem <%s>\n", FileName);
		    break;
	case 's':   statisticMethod = atoi(optarg);
			//printf("\t statisticMethod  <%d>\n", statisticMethod);
		    Check(statisticMethod, 1, 10000);
		    if(statisticMethod==1)
			{
				printf("\t Statistical Method: <CS>\n");
			}
			else if (statisticMethod==2)
			{
				printf("\t Statistical Method: <IGR>\n");
			}
			else
			{
				printf(" unrecognised option\n");
				exit(1);
			}
			break;

	case 'i':   InfoThres = atof(optarg);
            printf("\t optarg=  <%s>\n", optarg);
			printf("\t Informativeness threshold  <%f>\n", InfoThres);
	/*		Check(InfoThres, 0.0001, 1);*/
			break;

	case '?':   printf("unrecognised option\n");
		    exit(1);
	}
    }

    /*  Initialise  */


	//Get data

    GetNames();

	GetData(".data");

	AttributeFreq = (float *) calloc( MaxAtt+1, sizeof(float));
	HighWeightAtt = (long *) calloc( MaxAtt+1, sizeof(long));

	AttrFreqPercent = (float *) calloc( MaxAtt+1, sizeof(float));
	AttributeInfro = (float *) calloc( MaxAtt+1, sizeof(float));


	ForEach(t, 0, MaxAtt)
    {
		AttributeFreq[t] = 0;
		AttrFreqPercent[t] = 0.000000;
    }
	SumAttributeFreq = 0;
	SumHighWeightAttFreq = 0;

    ForEach(t, 0, MaxAtt)
    {
		HighWeightAtt[t] = 0;
    }

	//Get informativeness
	if(statisticMethod==1)
	{
		ChiQuareInfroValue(0, MaxItem);
	}
	else if (statisticMethod==2)
	{
		InfoGainInfroValue(0, MaxItem);
	}
	else
	{
		exit(0);
	}


	for(s=0; s<=MaxAtt; s++)
	{
		SumAttributeFreq += 1;

		if( HighWeightAtt[s] == 1)
		{
			SumHighWeightAttFreq +=1;
		}
	}


	if(statisticMethod==1)
	{
		printf("CS\n");
	}
	else if (statisticMethod==2)
	{
		printf("IGR\n");
	}

	printf("Informativeness threshold: %f\n",InfoThres);
	printf("Proportion: %f\n",SumHighWeightAttFreq/SumAttributeFreq);


	//Free Memory
	for(ii=0;ii<= MaxItem;ii++)
	{
		free(Item[ii]);
        Item[ii]=NULL;
	}
	free(Item);
	Item = NULL;

	free(AttName);
	AttName =NULL;

	free(MaxAttVal);
	MaxAttVal =NULL;

    free(SpecialStatus);
	SpecialStatus =NULL;

	for(ii=0;ii< 100;ii++)
	{
		free(AttValName[ii]);
		AttValName[ii] =NULL;
	}
	free(AttValName);
	AttValName=NULL;


	//  Open output file/
	strcpy(outFile, FileName);
	strcat(outFile, ".out");

	if ( ! ( Pn = fopen(outFile, "ab+") ) )  Error(0, Pn, "");

	if(statisticMethod==1)
	{
		fprintf(Pn,"CS\n");
	}
	else if (statisticMethod==2)
	{
		fprintf(Pn,"IGR\n");
	}

	fprintf(Pn,"Informativeness threshold: %f\n",InfoThres);
	fprintf(Pn,"Proportion: %f\n",SumHighWeightAttFreq/SumAttributeFreq);

	fclose(Pn);

	free(AttributeFreq);
	AttributeFreq =NULL;

	free(HighWeightAtt);
	HighWeightAtt = NULL;


    exit(0);

}
