/*************************************************************************/
/*								                                    	 */
/*    Library for function   	                                         */
/*    ---------------------------------------------------------	     	 */
/*								                                     	 */
/*************************************************************************/


#include "defns.h"
#include "types.h"
#include "extern.h"


ItemCount
	*Weight,	/* Weight[i]  = current fraction of item i */
	**Freq,		/* Freq[x][c] = no. items of class c with outcome x---cart(Ci,d) */
	*ValFreq,	/* ValFreq[x]   = no. items with outcome x---cart(Di) */
	*ClassFreq;	/* ClassFreq[c] = no. items of class c */
//C45
float
	*Gain,		/* Gain[a] = info gain by split on att a */
	*Info;		/* Info[a] = potential info of split on att a */


float	*UnknownRate;	/* UnknownRate[a] = current unknown rate for att a */



Boolean
	*Tested,	/* Tested[a] set if att a has already been tested */
	MultiVal;	/* true when all atts have many values */




/*************************************************************************/
/*							                                     	 	 */
/*		Allocate space		                                          	 */
/*						                                      		 	 */
/*************************************************************************/


    InitialiseData()

/*  ------------------  */
{ 
    DiscrValue v;
    Attribute a;

    Tested	= (char *) calloc(MaxAtt+1, sizeof(char));

	Gain	= (float *) calloc(MaxAtt+1, sizeof(float));
	Info	= (float *) calloc(MaxAtt+1, sizeof(float));

    Weight = (ItemCount *) calloc(MaxItem+1, sizeof(ItemCount));

    Freq  = (ItemCount **) calloc(MaxDiscrVal+1, sizeof(ItemCount *));//MaxDiscrVal䣬ʼΪ2
    ForEach(v, 0, MaxDiscrVal)
    {
	Freq[v]  = (ItemCount *) calloc(MaxClass+1, sizeof(ItemCount));
    }

    ValFreq = (ItemCount *) calloc(MaxDiscrVal+1, sizeof(ItemCount));
    ClassFreq = (ItemCount *) calloc(MaxClass+1, sizeof(ItemCount));


    UnknownRate = (float *) calloc(MaxAtt+1, sizeof(float));

    /*  Check whether all attributes have many discrete values  */

    MultiVal = true;

}


    freeData()
/*  ------------------  */
{ 
    DiscrValue v;
    Attribute a;

   	free(Tested);

	free(Gain);
	free(Info);

	free(Weight);

    ForEach(v, 0, MaxDiscrVal)
    {
	  free(Freq[v]);
	  Freq[v] = NULL;
    }
	free(Freq);
	Freq = NULL;

   	free(ValFreq);
	free(ClassFreq);



	free(UnknownRate);

}





/*************************************************************************/
/*								                                     	 */
/*		Initialise the weight of each item	                    	 	 */
/*								                                     	 */
/*************************************************************************/


    InitialiseWeights()
/*  -----------------  */
{
    ItemNo i;

    ForEach(i, 0, MaxItem)
    {
        Weight[i] = 1.0;
    }
}








/*************************************************************************/
/*								 	                                     */
/*	Return the total weight of items from Fp to Lp		             	 */
/*								                                      	 */
/*************************************************************************/


ItemCount CountItems(Fp, Lp)
/*        ----------  */
    ItemNo Fp, Lp;
{
    register ItemCount Sum=0.0, *Wt, *LWt;

    if ( AllKnown ) return Lp - Fp + 1;

    for ( Wt = Weight + Fp, LWt = Weight + Lp ; Wt <= LWt ; )
    {
	Sum += *Wt++;
    }

    return Sum;
}



/*************************************************************************/
/*                                                                  	 */
/*		Exchange items at a and b			                           	 */
/*								                                    	 */
/*************************************************************************/


void Swap(a,b)
/*   ----  */
    ItemNo a, b;
{
    register Description Hold;
    register ItemCount HoldW;

    Hold = Item[a];
    Item[a] = Item[b];
    Item[b] = Hold;

    HoldW = Weight[a];
    Weight[a] = Weight[b];
    Weight[b] = HoldW;
}
