/*************************************************************************/
/*							                                    		 */
/*		Type definitions for feature informativeness                  	 */
/*              -------------------------		                   		 */
/*									                                     */
/*************************************************************************/


typedef  char	Boolean, *String, *Set;

typedef  long	ItemNo;		/* data item number */
typedef  float	ItemCount;	/* count of (partial) items */

typedef  long	ClassNo,	/* class number, 0..MaxClass */
		DiscrValue;	/* discrete attribute value (0 = ?) */
typedef  short	Attribute;	/* attribute number, 0..MaxAtt */

typedef  union  _attribute_value
	 {
	    DiscrValue	_discr_val;
	    float	_cont_val;
	 }
	 	AttValue, *Description;

#define  CVal(Case,Attribute)   Case[Attribute]._cont_val
#define  DVal(Case,Attribute)   Case[Attribute]._discr_val//	DVal(SampleDvec,Att)=Dv;
#define  Class(Case)		Case[MaxAtt+1]._discr_val

#define  Unknown  -999		/* unknown value for continuous attribute */


#define  BrDiscr	1	/* node types:	branch */
#define  ThreshContin	2	/*		threshold cut */
#define  BrSubset	3	/*		subset test */

#define  IGNORE		1	/* special attribute status: do not use */
#define  DISCRETE	2	/* ditto: collect values as data read */
