package history;
/**
 * <p>Title: GraphEdge</p>
 * <p>Description: A GraphEdge describes an edge(connection between two clusters) of the Evolution Graph</p>
 * @author Eirini Ntoutsi
 * @version 1.0
 */
public class GraphEdge {
    GraphNode fromNode;
    GraphNode toNode;
    double overlap;
    String externalTransition;
    //for the size
    double sizeInternalTransition;
    String sizeInternalTransitionStr;
    //for the compactness
    double compactnessInternalTransition;
    String compactnessInternalTransitionStr;
    //for the location
    double locationInternalTransition;
    String locationInternalTransitionStr;
     boolean deleted; //internal variable

    public GraphEdge() {
        overlap = -1;
        externalTransition = "";
        sizeInternalTransitionStr = "";
        compactnessInternalTransitionStr = "";
        locationInternalTransitionStr = "";
        sizeInternalTransition = -1;
        compactnessInternalTransition = -1;
        locationInternalTransition = -1;
        fromNode = null;
        toNode = null;
    }
    public GraphEdge(GraphNode from, GraphNode to, double noverlap, String extTrans,
            String sizeTransStr, double sizeTrans,
            String compactnessTransStr, double compactnessTrans,
            String locationTransStr, double locationTrans) {
        fromNode = from;
        toNode = to;
        overlap = noverlap;
        externalTransition =extTrans;
        sizeInternalTransitionStr = sizeTransStr;
        compactnessInternalTransitionStr = compactnessTransStr;
        locationInternalTransitionStr = locationTransStr;
        sizeInternalTransition = sizeTrans;
        compactnessInternalTransition = compactnessTrans;
        locationInternalTransition = locationTrans;
    }


    public GraphNode getToNode(){
        return toNode;
    }


    public String getExternalTransition(){
        return externalTransition;
    }
    public double getSizeInternalTransition(){
        return sizeInternalTransition;
    }
    public String getSizeInternalTransitionLabel(){
        return sizeInternalTransitionStr;
    }
    public void setSizeInternalTransitionLabel(String level){
        sizeInternalTransitionStr=level;
    }
    public void setExternalTransitionLabel(String label){
       externalTransition=label;
    }

    public void setSizeInternalTransition(double value){
        sizeInternalTransition=value;
    }

    public void setOverlap(double value){
        overlap=value;
    }

    public double getCompactnessInternalTransition(){
        return compactnessInternalTransition;
    }
    public String getCompactnessInternalTransitionLabel(){
        return compactnessInternalTransitionStr;
    }
    public void setCompactnessInternalTransitionLabel(String level){
        compactnessInternalTransitionStr=level;
    }
    public void setCompactnessInternalTransition(double value){
        compactnessInternalTransition=value;
    }

    public double getLocationInternalTransition(){
        return locationInternalTransition;
    }
    public String getLocationInternalTransitionLabel(){
        return locationInternalTransitionStr;
    }
    public void setLocationInternalTransitionLabel(String level){
        locationInternalTransitionStr=level;
    }
    public void setLocationInternalTransition(double value){
        locationInternalTransition=value;
    }

    public void setStartNode(GraphNode start){
        fromNode = start;
    }
    public void setEndNode(GraphNode end){
        toNode = end;
    }

    //print graphEdge
    public String toString(){
        String res="";
        res = "(#"+fromNode.getID()+")"+fromNode.toString()+": {"+overlap+"} ---"+externalTransition;
        if (getSizeInternalTransition()>0)
            res += "["+getSizeInternalTransitionLabel()+":"+getSizeInternalTransition()+"]";
        if (getCompactnessInternalTransition()>0)
            res += "["+getCompactnessInternalTransitionLabel()+":"+getCompactnessInternalTransition()+"]";
        if (getLocationInternalTransition()>0)
            res += "["+getLocationInternalTransitionLabel()+":"+getLocationInternalTransition()+"]";
        res += "---> "+toNode.toString()+" (#"+toNode.getID()+")";
        return(res);
    }
    //print graphEdge without the end node
    public String toString2(){
        String res="";
        res = fromNode.toString()+": {"+overlap+"} ---"+externalTransition;
        if (getSizeInternalTransition()>0)
            res += "["+getSizeInternalTransitionLabel()+":"+getSizeInternalTransition()+"]";
        if (getCompactnessInternalTransition()>0)
            res += "["+getCompactnessInternalTransitionLabel()+":"+getCompactnessInternalTransition()+"]";
        if (getLocationInternalTransition()>0)
            res += "["+getLocationInternalTransitionLabel()+":"+getLocationInternalTransition()+"]";
        res += "---> ";//+toNode.toString();
        return(res);
    }

    public void setDeletedStatus(boolean state){
        this.deleted = state;
    }




}
