package history;
import java.util.*;
import utils.*;

class Comparer implements Comparator {
    public int compare(Object inst1, Object inst2)
    {
        int i1 = ((NumericInstance)inst1).getInstanceID();
        int i2 = ((NumericInstance)inst2).getInstanceID();
        return Math.abs(i1) - Math.abs(i2);
    }
}
/**
 * <p>Title: GraphLevelNodes</p>
 * <p>Description: A GraphLevelNodes describes a level of the graph, 
 * i.e. a set of nodes with the same timestamp, i.e. a clustering</p>
 * <p>@author: Eirini Ntoutsi </p>
 * @version 1.0
 */
public class GraphLevel {
    Vector graphNodes; //a vector of nodes belonging to this level
    String name;// the label of this level
    int ID;
    int time; //the time to which this level corresponds to
    String randDetails;
 
    /**************************************************************************/
    //constructor
    public GraphLevel(Vector theNodes, int ttime, String tname, int tID) {
        name = tname;
        time = ttime;
        graphNodes = theNodes;
        ID = tID;
        randDetails="";
    }
  
    /**************************************************************************/
    public GraphNode getNode (int i){
        return (GraphNode)graphNodes.get(i);
    }


   
    /**************************************************************************/
    public int getSize(){
        return graphNodes.size();
    }


    
    /**************************************************************************/
    public String toString(){
        String res = "";
        for (int i=0; i<this.getSize(); i++){
            res += (this.getNode(i)).printNodeOutEdges();
            if ((this.getNode(i)).getNumOfOutEdges()==0)
                res += (this.getNode(i)).getName()+"("+this.getNode(i).getTimeStart()+","+this.getNode(i).getTimeEnd()+")\n";
        }
        return res;
    }

}
