/**
 * <p>Title: Monitor class</p>
 * <p>@author: Eirini Ntoutsi </p>
 * @version 1.0
 */
package monitor;
//import panda.*;
import java.util.*;
import types.*;
import database.Database;
import utils.*;
import java.sql.*;

public class Monitor{
    panda.types.ComplexPattern P1; //from
    panda.types.ComplexPattern P2; //to
    MMatrix matrix; //overlaps
    double survivalThreshold; //survival threshold
    double splitThreshold; //split threshold
    double sizeThreshold; //size threshold
    double locationThreshold; //location threshold
    double compactnessThreshold; //compactness threshold
    
    int survivalsCnt; //# survivals
    int disappearancesCnt; //# disappearances
    int appearancesCnt; //# appearances
    int splitsCnt; //# splits
    int absorptionsCnt; //# absorptions
    int survivalsExpandCnt;//# survivals with expand
    int survivalsShrinkCnt;//# survivals with shrink
    int survivalsNoChangeInSizeCnt;//# survivals with no change in size
    int survivalsShiftCnt;//#survivals with shift in location
    int survivalsNoShiftCnt;//#survivals with no shift in location
    int survivalsCompactnessMoreCompactCnt;//#survivals with changeInCompactness - more compact
    int survivalsCompactnessMoreDiffuseCnt;//#survivals with changeInCompactness - more diffuse
    int survivalsCompactnessNochangeCnt;//#survivals with changeInCompactness - more diffuse
    Vector DBres;//info for the DB
    Database DB;
    String clusterType;//BaseCluster, A, B2

    /**
     * Constructor
     **/
    public Monitor(Database DataB, MMatrix tmatrix, double survival, double split, 
                    double sizeThresh, double locationThresh,double compactnessThresh,
                    panda.types.ComplexPattern p1, panda.types.ComplexPattern p2,String type)
                    throws panda.types.IllegalTypeException{
        P1 = p1; P2 = p2; matrix = tmatrix;
        survivalThreshold = survival; splitThreshold = split;
        sizeThreshold = sizeThresh; locationThreshold = locationThresh;
        compactnessThreshold = compactnessThresh;
        survivalsCnt = 0; disappearancesCnt = 0;
        appearancesCnt = 0; splitsCnt = 0;
        absorptionsCnt = 0; survivalsNoChangeInSizeCnt = 0;
        survivalsExpandCnt = 0; survivalsShrinkCnt = 0;
        survivalsShiftCnt = 0;  survivalsNoShiftCnt = 0;
        survivalsCompactnessMoreCompactCnt = 0;
        survivalsCompactnessMoreDiffuseCnt = 0;
        survivalsCompactnessNochangeCnt = 0;
        DBres = new Vector();
        DB = DataB;
        clusterType = type;
        externalTransitions();
    }

    /**
     * Detect the external transitions
     **/
    public String externalTransitions(){
        String res = "";
        res = externalTransitionsForBaseClusters();
        return res;
    }
       
    /**
     * Detect the external transitions for clusters of type: BaseCluster (aka set of instance-members)
     **/
    public String externalTransitionsForBaseClusters(){
        double overlap;
        Vector results = new Vector();
        Vector absorptionsSurvivals = new Vector();
        Vector seenCLustersFromClustering2 = new Vector();
        //for each cluster of the first clustering, i.e. rows of the matrix - clusters are ordered based on their IDs
        for (int i=0; i<matrix.getNumOfRows();i++){
            Vector splitCandidates = new Vector(); //a list of split candidates for this cluster
            Vector survivalCandidates = new Vector(); //a list of survival candidates for this cluster
            boolean isDisappearance = true;
            panda.types.Pattern X = P1.getPattern(i); //X comes from the first clustering
            //for each cluster of the second clustering, i.e. columns of the matrix - clusters are ordered based on their IDs
            for (int j=0; j<matrix.getNumOfColumns();j++){
                panda.types.Pattern Y = P2.getPattern(j); //Y comes from the second clustering
                overlap = matrix.getValueAtPositions(i,j); //X, Y overlap
                if (overlap >= survivalThreshold){//is survival?
                    survivalCandidates.add(Y);
                }
                else if (overlap >= splitThreshold){//is split?
                    splitCandidates.add(Y);
                }
            }//end for j
            String clusterNameFrom = X.getName();
            if (splitCandidates.size() > 1){//--check if it is a split or a disappearance
                isDisappearance = false;
                double splitsUnionOverlap = 0.0;
                try{ //compute the union of all candidate splits
                    splitsUnionOverlap = getScore(X, splitCandidates);
                }
                catch (Exception e){
                    System.out.println("Error: " + e.toString() + e.getMessage());
                }
                if (splitsUnionOverlap > survivalThreshold){ //it is a valid split
                    for (int k = 0; k < splitCandidates.size(); k++) {
                        String clusterTransition = "split";
                        String clusterNameTo = ((panda.types.Pattern)(splitCandidates.get(k))).getName();
                        results.add("("+clusterNameFrom+","+clusterTransition+","+clusterNameTo+")"+"\n");
                        double weight = matrix.getValueForLabels(clusterNameFrom,clusterNameTo);
                        DBres.add("clusterNameFrom:"+clusterNameFrom+",clusterNameTo:"+clusterNameTo+",transitionType:external,clusterTransition:"+clusterTransition+",transitionWeight:"+weight);
                        splitsCnt++;
                        seenCLustersFromClustering2.add(((panda.types.Pattern)(splitCandidates.get(k))));
                    }
                }
                else { //it is a disappearance
                    String clusterTransition = "disappearance";
                    String clusterNameTo = "null";
                    results.add("(" +clusterNameFrom + "," + clusterTransition + "," +
                                clusterNameTo + ")" + "\n");
                    DBres.add("clusterNameFrom:"+clusterNameFrom+",clusterNameTo:"+clusterNameTo+",transitionType:external,clusterTransition:"+clusterTransition);
                    disappearancesCnt++;
                }
            }
            
            if (survivalCandidates.size()>0){//all survival candidates are absorptionsurvival candidates
                isDisappearance = false;
                for (int k=0; k <survivalCandidates.size();k++){
                    Vector tmp = new Vector();
                    tmp.add(X);
                    tmp.add((panda.types.Pattern)(survivalCandidates.get(k)));
                    absorptionsSurvivals.add(tmp);
                }
            }

            if (isDisappearance) { //--it is a disappearance
                String clusterTransition = "disappearance";
                String clusterNameTo  = "null";
                results.add("("+clusterNameFrom+","+clusterTransition+","+clusterNameTo+")"+"\n");
                DBres.add("clusterNameFrom:"+clusterNameFrom+",clusterNameTo:"+clusterNameTo+",transitionType:external,clusterTransition:"+clusterTransition);
                disappearancesCnt++;
            }
        }//end for i

        //go on with absorptions preprocessing now
        //for each cluster of the 2nd clustering, i.e. columns of the matrix
        for (int j=0; j<matrix.getNumOfColumns();j++){
            panda.types.Pattern Y = P2.getPattern(j); //Y comes from the second clustering
            int candidatesForYCnt=0;//the number of cluster candidates for Y
            for (int z=0; z<absorptionsSurvivals.size(); z++){
                Vector tmp = (Vector)absorptionsSurvivals.get(z);
                panda.types.Pattern fromClustering2 = (panda.types.Pattern)tmp.get(1);
                if (Y.getName().equals(fromClustering2.getName()))
                    candidatesForYCnt++;
            }
            if (candidatesForYCnt>0){ //if there are any candidates
                if (candidatesForYCnt == 1) { //Y is a survival for some X cluster
                    for (int z=0; z<absorptionsSurvivals.size(); z++){
                        Vector tmp = (Vector)absorptionsSurvivals.get(z);
                        panda.types.Pattern X = (panda.types.Pattern)tmp.get(0);
                        panda.types.Pattern fromClustering2 = (panda.types.Pattern)tmp.get(1);
                        if (Y.getName().equals(fromClustering2.getName())){
                            String clusterNameFrom = X.getName();
                            String clusterTransition = "survival";
                            String clusterNameTo = Y.getName();
                            results.add("("+clusterNameFrom+","+clusterTransition+","+clusterNameTo+")"+"\n");
                            survivalsCnt++;
                            seenCLustersFromClustering2.add(((panda.types.Pattern) (Y)));
                            break;//if cluster found stop searching
                        }//if
                    }//for
                } //if survival
                else { //Y has absorbed many X clusters
                    for (int l = 0; l < absorptionsSurvivals.size(); l++) {
                        Vector tmp = (Vector) absorptionsSurvivals.get(l);
                        panda.types.Pattern X = (panda.types.Pattern) tmp.get(0);
                        String clusterNameFrom = X.getName();
                        panda.types.Pattern fromClustering2 = (panda.types.Pattern)tmp.get(1);
                        String clusterNameTo = Y.getName();
                        String clusterTransition = "absorption";
                        if (Y.getName().equals(fromClustering2.getName())){
                            results.add( "(" +clusterNameFrom + "," + clusterTransition +
                                        "," + clusterNameTo + ")" + "\n");
                            double weight = matrix.getValueForLabels(clusterNameFrom,clusterNameTo);
                            DBres.add("clusterNameFrom:"+clusterNameFrom+",clusterNameTo:"+clusterNameTo+",transitionType:external,clusterTransition:"+clusterTransition+",transitionWeight:"+weight);
                            absorptionsCnt++;
                            seenCLustersFromClustering2.add(((panda.types.Pattern)(Y)));
                        }
                    }
                }
            }//if there are candidates for y
            candidatesForYCnt = 0; //initialize this
        }//for j

        //if some cluster from clustering2 does not participate in any transition
        //then it is a new cluster
        for (int cl2=0; cl2<P2.getSize(); cl2++){
            String cl2Name = (P2.getPattern(cl2)).getName();
            boolean found = false;
            for (int seen=0; seen<seenCLustersFromClustering2.size(); seen++){
                String tmp = ((panda.types.Pattern)seenCLustersFromClustering2.get(seen)).getName();
                if (cl2Name.equals(tmp))
                    found=true;
            }
            if (found==false){
                String clusterNameFrom = "null";
                String clusterTransition = "appearance";
                String clusterNameTo = cl2Name;
                results.add("("+clusterNameFrom + "," + clusterTransition +
                            "," + clusterNameTo + ")" + "\n");
                DBres.add("clusterNameFrom:"+clusterNameFrom+",clusterNameTo:"+clusterNameTo+",transitionType:external,clusterTransition:"+clusterTransition);
                appearancesCnt++;
            }
        }
        results.add("--- Count External Transitions ---");
        results.add("#survivals = "+survivalsCnt);
        results.add("#disappearances = "+disappearancesCnt);
        results.add("#absorptions = "+absorptionsCnt);
        results.add("#splits = "+splitsCnt);
        results.add("#appearances = "+appearancesCnt);

        String res="";
        for (int i=0; i<results.size();i++)
            res += results.get(i)+"\n";
        return res;
    }


       
    //returns the overlap of a cluster with a set of clusters
    public double getScore(panda.types.Pattern p1, Vector patternList) throws panda.types.IllegalTypeException, panda.dissimilarity.ScoreException {
        double res = -1.0;
        double union = 0.0;
        for (int i=0; i<patternList.size(); i++){
            panda.types.Pattern p2 = (panda.types.Pattern)patternList.get(i);
            if (p1.getClass() != p2.getClass())
                throw new panda.types.IllegalTypeException ("Pattern types not comparable "+p1.getName()+" e "+p2.getName());
            else
                union += p1.getScore(p2);
        }
    return union;
    }
    
    
    
    
    
   
    /**
     * Save running results into the db
     **/    
    public void toDB(int experimentID){
        int runningID = -1;
        //--- store running parameters ---//
        try {
            //insert running params
            String sql ="INSERT INTO tbl_runnings(fk_experimentID, fk_first_clusteringID,fk_second_clusteringID) VALUES("+
                 experimentID+","+((SetOfClusters)P1).getID()+","+((SetOfClusters)P2).getID()+")";
            DB.execute(sql);
            //get running ID
            sql = "SELECT max(pk_runningID) as runningID FROM tbl_runnings";
            ResultSet rs2 = DB.execSelectQuery(sql);
            rs2.next();
            runningID = rs2.getInt("runningID");
            rs2.close();
        }
        catch (SQLException s){System.out.println("SQL Error (store running params): " + s.toString() + " " +s.getErrorCode() + s.getSQLState());}
        catch (Exception e){System.out.println("Error: (store running params)" + e.toString() + e.getMessage());}
        if (runningID>0){ //just for valid runnings
            //--- store detected transitions ---//
            int clusterNameFrom=-1, clusterNameTo=-1;
            String transitionType="",clusterTransition="";
            String internalType="",internalValue="",transitionDiff="",weight="0";
            String clusterNameFromStr="",clusterNameToStr="";
            for (int i=0; i< DBres.size(); i++){
                String tmpStr = (String)DBres.get(i);
                String[] tokens = tmpStr.split(",");
                for (int j=0; j<tokens.length; j++){
                    String token = tokens[j];
                    if (token.startsWith("clusterNameFrom:")){
                        clusterNameFromStr = token.replace("clusterNameFrom:", "");
                        clusterNameFrom = DB.getClusterID(clusterNameFromStr);
                    }
                    else if (token.startsWith("clusterNameTo:")){
                        clusterNameToStr = token.replace("clusterNameTo:", "");
                        clusterNameTo = DB.getClusterID(clusterNameToStr);
                    }
                    else if(token.startsWith("transitionType:"))
                        transitionType = token.replace("transitionType:","");
                    else if (token.startsWith("clusterTransition:"))
                        clusterTransition = token.replace("clusterTransition:","");
                    else if (token.startsWith("fld_internalType:"))
                        internalType = token.replace("fld_internalType:","");
                    else if (token.startsWith("fld_internalValue:"))
                        internalValue = token.replace("fld_internalValue:","");
                    else if (token.startsWith("fld_transitionDiff:"))
                        transitionDiff = token.replace("fld_transitionDiff:","");
                    else if (token.startsWith("transitionWeight:"))
                        weight = token.replace("transitionWeight:","");
                }
                //Database DB2 = new Database();            
                String sql="";            
                if (internalType.length()>0){//it has an internal transition also
                    clusterTransition = "survival";
                    sql=" INSERT INTO tbl_transitions(fk_runningID,fk_clusterID_from,fk_clusterID_to, "+
                            " fld_externalType,fld_internalType,fld_internalValue,fld_transitionDiff," +
                            "fld_overlap) "+
                        " VALUES("+
                            runningID+","+clusterNameFrom+","+ clusterNameTo+","+
                            "'"+clusterTransition+"','"+internalType+"','"+internalValue+"',"+transitionDiff+
                            ","+weight+")";
                    try {
                        DB.execute(sql);
                        //DB2.execute(sql);
                    }
                    catch (SQLException s){System.out.println("SQL Error (store transitions (if)): "+s+" "+s.getErrorCode() +s.getSQLState()+"\n"+sql+"\t from: "+clusterNameFromStr+" --> \t to: "+clusterNameToStr);                    }
                    catch (Exception e) {System.out.println("Error (store transitions (if)): "+e+e.getMessage()+"\n"+sql+"\t from: "+clusterNameFromStr+" --> \t to: "+clusterNameToStr);}
                    
                }
                else{ //its an external transition
                    sql=" INSERT INTO tbl_transitions(fk_runningID,fk_clusterID_from,fk_clusterID_to, "+
                           "fld_externalType,fld_overlap) VALUES("+runningID+","+clusterNameFrom+","+
                           clusterNameTo+","+"'"+clusterTransition+"',"+weight+")";
                    try {
                        DB.execute(sql);
                        //DB2.execute(sql);
                    }
                    catch (SQLException s){System.out.println("SQL Error (store transitions (else)): "+s+" "+s.getErrorCode() +s.getSQLState()+"\n"+sql+"\t from: "+clusterNameFromStr+" --> \t to: "+clusterNameToStr);                    }
                    catch (Exception e) {System.out.println("Error (store transitions (else)): "+e+e.getMessage()+"\n"+sql+"\t from: "+clusterNameFromStr+" --> \t to: "+clusterNameToStr);}
                }   
                //DB2.terminateConnection();
                tmpStr=""; clusterTransition="";
                internalType=""; internalValue=""; transitionDiff=""; 
                clusterNameFromStr=""; clusterNameToStr="";
                clusterNameFrom=-1; clusterNameTo=-1; weight="0";
            }//for DBres
        }
    }
}//end of file
