/**
 * <p>Title: Monitoring of consequtive timepoint clusterings</p>
 * @author Eirini Ntoutsi
 * @version 1.0
*/
package test;
import monitor.Monitor;
import database.Database;
import types.SetOfClusters;
import utils.MMatrix;
import java.util.*;
//this is I am working on***********
public class TestMonitorConsequtiveTimePoints {
    static int datasetID = 5;
    //the type of cluster
    //static String clusterType = "BaseCluster";
    static String clusterType = "Gaussian_and_BaseCluster";
    //the survival transition threshold (external)
    static double survivalThreshold = 0.5;//***SOS***
    //the split transition threshold (external)
    static double splitThreshold = 0.2;//***SOS***
    //the size transition threshold (internal)
    static double sizeThreshold = 0.2;//***SOS***
    //the location transition threshold (internal)
    static double locationThreshold = 0.2;//0.2;//***SOS***
    //the compactness transition threshold (internal)
    static double compactnessThreshold = 0.2;//0.2;//***SOS***
    
    public static void main (String[] args) {
        try{
            Database DB = new Database();
            String myDatasetName = DB.getDatasetName(datasetID);
            DB.setDataset(myDatasetName);
            //-- get clusterings IDs for this dataset
            Vector clusteringsIDs = DB.getClusterings(datasetID);
            int experimentID = DB.createExperiment(datasetID, survivalThreshold, splitThreshold, 
                                                   sizeThreshold,myDatasetName,clusterType);
            for (int i=0; i<clusteringsIDs.size()-1;i++){
                //-- 1st clustering
                int ID1 = (new Double((String)(clusteringsIDs.get(i)))).intValue();
                SetOfClusters fromClustering = DB.getClustering_Clusters(ID1,clusterType);
                //-- 2nd clustering
                int ID2 = (new Double((String)(clusteringsIDs.get(i+1)))).intValue();
                SetOfClusters toClustering = DB.getClustering_Clusters(ID2,clusterType);
                //-- find overlap between clusters of 1st,  2nd clusterings
                MMatrix overlapsMatrix = fromClustering.overlap(toClustering,clusterType);
                //-- start monitoring //NA BGALO TO DB param apo to MONITOR(
                Monitor monitor = new Monitor(DB,overlapsMatrix, 
                                        survivalThreshold, splitThreshold, 
                                        sizeThreshold, locationThreshold, compactnessThreshold,
                                        fromClustering, toClustering,clusterType);
                //-- save results into the DBMonitor
                monitor.toDB(experimentID);
            }
        }
        catch(Exception e)
        {
            System.out.println("Error: "+e.toString()+e.getMessage());
        }
     }
}//end of file