package test;
/**
 * <p>Title: Test Offline Compression</p>
 * <p>Description: Testing offline compression over the whole evolution graph</p>
 * @author Eirini Ntoutsi
 * @version 1.0
 */
import database.Database;
import history.*;
public class TestOfflineCompression{

    public static void main (String[] args) {
        int experimentID = 164; //the experimentID
        int startTPoint=0, endTPoint=239; //how many time points to consider
        double maxCentroidsDistance = 0.1; //the maximum distance threshold

        String path="C:/Eirini/"; //store the results
        //--- Load graph from the DB ---//
        Database DB = new Database();
        int experimentDatasetID = DB.getExperimentDatasetID(experimentID);
        String datasetName = DB.getDatasetName(experimentDatasetID); //which dataset is used;
        DB.setDataset(datasetName);
              
        // --- Load nodes
        GraphHistory history = DB.getHistory(experimentDatasetID,startTPoint,endTPoint);
        
        // --- Load edges
        DB.loadHistoryEdges(history,experimentID);
        
        //--- Compute offline FINGERPRINT (offlineFEG) ---//
        history.fingerprint(startTPoint,endTPoint,maxCentroidsDistance);
        history.evaluateOfflineFingerprintInfoLoss(startTPoint,endTPoint);
        StringBuffer compressionResults = history.getFingerprintResults();
        utils.Functions.toFile(path,"offlineFEG_[infoLoss]_experiment"+experimentID+"_["+maxCentroidsDistance+"].txt", compressionResults);
        history.evaluateOfflineFingerprintSize(startTPoint,endTPoint);
        int[] compressedCntPerLevelOfflineCompression = history.getOfflineCompressionStats_size();
        utils.Functions.toFile(path,"offlineFEG_[size]_experiment"+experimentID+"["+maxCentroidsDistance+"].txt",new StringBuffer(utils.Functions.printArray(compressedCntPerLevelOfflineCompression)));
        DB.terminateConnection();//close DB connection
    }
    
}