package test;
/**
 * <p>Title: Test Online Compression</p>
 * <p>Description: Testing online compression over the evolution graph</p>
 * @author Eirini Ntoutsi
 * @version 1.0
 */
import database.Database;
import history.*;
public class TestOnlineCompression{
    public static void main (String[] args) {
        int experimentID = 164; //the experimentID
        int startTPoint=0, endTPoint=239; //how many time points to consider
        double maxCentroidsDistance = 0.1; //the maximum distance threshold

        String path="C:/Eirini/"; //store the results
        String fileName="onlineFEG_experiment"+experimentID+"["+maxCentroidsDistance+"].txt";
        
        //--- Load graph from the DB ---//
        Database DB = new Database();
        int experimentDatasetID = DB.getExperimentDatasetID(experimentID);
        String datasetName = DB.getDatasetName(experimentDatasetID); //which dataset is used;
        DB.setDataset(datasetName);

        // --- Load nodes
        GraphHistory history = DB.getHistory(experimentDatasetID,startTPoint,endTPoint);

        // --- Load edges
        DB.loadHistoryEdges(history,experimentID);
        
        //--- Compute online FINGERPRINT (onlineFEG) ---//
        GraphCompression onlineFEGCompression = new GraphCompression(history, false);
        onlineFEGCompression.doCompression_SurvivalsWithChangesAndIntensionClose(startTPoint,endTPoint,maxCentroidsDistance);
        StringBuffer compressionResults = onlineFEGCompression.getCompressionResults();
        utils.Functions.toFile(path,fileName,compressionResults);
        DB.terminateConnection();//close DB connection
    }
}
