/**
 * <p>Title: BaseCluster</p>
 * <p>Description: A BaseCluster is modeled as a set of its member-instances</p>
 * <p>@author: Eirini Ntoutsi </p>
 * @version 1.0
 */
package types;
import utils.*;
import java.text.DecimalFormat;

public class BaseCluster extends panda.types.SimplePattern{
    private int ID; // the ID
    private ClusterInstances instances; //the instances that comprise the cluster
    


    
    public BaseCluster(int tID,String theName, ClusterInstances theInstances){
        super(theName);
        ID = tID;
        instances = theInstances;
    }
    
    @Override
    public String getName(){
        return name;
    }



 
    public ClusterInstances getInstances(){
        return instances;
    }
    
    public int getSize(){
        return instances.getInstancesCnt();
    }
    
    @Override
    public String toString(){
        DecimalFormat dec = new DecimalFormat("0.00");
        String res = "=== Cluster name: "+this.getName()+"===\n";
        res += "#members: "+this.getSize()+"\n";
        if (this.getInstances() != null)
            res += this.getInstances().toString()+"\n";
        return res;
    }
    
/* -- functions that all classes derived from the SimplePattern class (PANDA) should implement -- */
    /*
     *Returns the cluster type
     */
    public String getType(){
        return "BaseCluster";
    }
    
    /*
     *The similarity score between two BaseClusters is the overlap of their member-instances
     */
    public double getScore(panda.types.Pattern p2) throws panda.types.IllegalTypeException, panda.dissimilarity.ScoreException {
        double res = 0.0;
        if (this.getClass()!=p2.getClass()){
            throw new panda.types.IllegalTypeException ("Pattern types not comparable "+this.getName()+" e "+p2.getName());
        }
        else{
            //the similarity is the intersection of the two sets, i.e. the number of common instances
            res = (this.getInstances()).overlap(((BaseCluster)p2).getInstances());
        }
        return res;
    }
    


    
    
    //returns the distance of measure components
    //Not implemented, just placed here
    public double getScoreMeasure(panda.types.Pattern p1)throws panda.types.IllegalTypeException, panda.dissimilarity.ScoreException{
        return -1.0;
    }
    //returns the distance of structure components
    //Not implemented, just placed here
    public double getScoreStruct (panda.types.Pattern p1) throws panda.dissimilarity.ScoreException{
        return 1.0;
    }
}