/*
 * Gaussian_and_BaseCluster.java
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package types;
import java.util.*;
import utils.*;
import java.text.DecimalFormat;

/*
 * <p>Description: A BaseGaussian_and_BaseClusterluster is modeled as a set of its member-instances plus some stats about these instances (mean, stddev)</p>
 * @author: Eirini Ntoutsi
 * @version 1.0
 */
public class Gaussian_and_BaseCluster extends panda.types.SimplePattern{
    private int ID; // the cluster ID
    private Vector attributes; //the attributes
    private Vector attributeMeans; //the attribute mean values
    private Vector attributeStdDevs; //the attribute stdDevs values
    private ClusterInstances instances; //the instances that comprise the cluster    
    
    /*
     *Constructor
     */     
    public Gaussian_and_BaseCluster(int tID,String theName, Vector attr, Vector means, Vector stdDevs,ClusterInstances insts ){
        super(theName);
        this.ID = tID;
        this.attributes = attr;
        this.attributeMeans = means;
        this.attributeStdDevs = stdDevs;
        this.instances = insts;
    }
    
    /* 
     *Returns the name of the cluster
     */
    public String getName(){
        return name;
    }

  
    /*
     *Returns the attribute names
     */
    public Vector getAttributes(){
        return attributes;
    }
    /*
     *Returns the attribute means
     */
    public Vector getAttributeMeans(){
        return attributeMeans;
    }
    
    /*
     *Returns the attribute stdDevs
     */
    public Vector getAttributeStdDevs(){
        return attributeStdDevs;
    }
    
    /*
     *returns the objects
     */
    public ClusterInstances getInstances(){
        return instances;
    }
    

    /*
     *Prints cluster info
     */
    public String toString(){
        DecimalFormat dec = new DecimalFormat("0.00");
        String res;
        res = this.getName()+"\t";
        for (int i=0;i<this.attributes.size();i++){
            res += this.attributes.get(i).toString()+"\t"+
                    (new Double(this.attributeMeans.get(i).toString()).doubleValue())+"\t"+
                    (new Double(this.attributeStdDevs.get(i).toString()).doubleValue())+"\n";
        }
        res+="------ Cluster instances ------\n";
        if (this.getInstances() != null)
            res += this.getInstances().toString()+"\n";
        
        return res;
    }
    
    /*
     *returns the number of instances for the cluster
     */
    public int getSize(){
        return instances.getInstancesCnt();
    }
    
/* -- functions that all derived classes should specify -- */
    /*
     *Returns the cluster type
     */
    public String getType(){
        return "Gaussian_and_BaseCluster";
    }
    


    public double getScore(panda.types.Pattern p2) throws panda.types.IllegalTypeException, panda.dissimilarity.ScoreException {
        double res = 0.0;
        if (this.getClass()!=p2.getClass()){
            throw new panda.types.IllegalTypeException ("Pattern types not comparable "+this.getName()+" e "+p2.getName());
        }
        else{
            res = (this.getInstances()).overlap(((Gaussian_and_BaseCluster)p2).getInstances());
        }
        return res;
    }

    
            
    //returns the distance of measure components
    //just placed here
    public double getScoreMeasure(panda.types.Pattern p1)throws panda.types.IllegalTypeException, panda.dissimilarity.ScoreException{
        return -1.0;
    }
    //returns the distance of structure components
    //just placed here
    public double getScoreStruct (panda.types.Pattern p1) throws panda.dissimilarity.ScoreException{
        return 1.0;
    }
    
    
    
    
}
