/**
 * <p>Title: Clustering class</p>
 * <p>Description: A clustering is a set of clusters resulted from the same running</p>
 * <p>@author: Eirini Ntoutsi </p>
 * @version 1.0
**/
package types;
import java.util.*;
import utils.*;

class Comparer implements Comparator {
    public int compare(Object inst1, Object inst2)
    {
        int i1 = ((NumericInstance)inst1).getInstanceID();
        int i2 = ((NumericInstance)inst2).getInstanceID();
        return Math.abs(i1) - Math.abs(i2);
    }
}
       
public class SetOfClusters extends panda.types.ComplexPattern{
    int ID;
    /**
     * a simple constructor
     **/
    public SetOfClusters (String name) throws panda.types.CreationException {
        super (name);
        ID = -1;
    }

    //get labels of clusters in this clustering
    public String[] getClustersLabels(){
        String tmp[] = new String[this.getSize()];
        for (int i=0; i<tmp.length;i++)
           tmp[i] = ((panda.types.Pattern)this.getPattern(i)).getName();
       return tmp;
    }
    
    /**
     * Returns a matrix of distances w.r.t. another clustering
     **/
    public MMatrix overlap(panda.types.ComplexPattern S, String clusterType)throws panda.types.IllegalTypeException, panda.dissimilarity.ScoreException {
        SetOfClusters S2 = (SetOfClusters)S;
        double [][] res = new double[this.getSize()][S2.getSize()];
        String[] theRowLabels = this.getClustersLabels();
        String[] theColsLabels = S2.getClustersLabels();
        MMatrix distMatrix = new MMatrix(res,theRowLabels,theColsLabels);
        distMatrix.initializeValues(0.0);
        for (int i=0; i<this.getSize(); i++){//from this. clustering
            panda.types.Pattern p1 = this.getPattern(i);
            String p1ID = p1.getName();
            for (int j=0; j<S2.getSize(); j++){//from S2 clustering
                panda.types.Pattern p2 = S2.getPattern(j);
                String p2ID = p2.getName();
                if (p1.getClass()!=p2.getClass())
                    throw new panda.types.IllegalTypeException ("Pattern types not comparable: "+this.getName()+" vs "+p2.getName());
                else{
                    double overlap = 0;
                    //--Computer overlap based on the cluster type
                    if (clusterType.equalsIgnoreCase("BaseCluster")){//type B1 clusters
                        overlap = ((BaseCluster)p1).getScore((BaseCluster)p2);
                    }
                    else if (clusterType.equalsIgnoreCase("Gaussian_and_BaseCluster")){//type B1+B2 clusters
                        overlap = ((Gaussian_and_BaseCluster)p1).getScore(((Gaussian_and_BaseCluster)p2));
                    }
                    else{
                        System.out.println("The cluster type is not {B1|B2|B1+B2}!!!!");
                    }
                    //update the distance matrix
                    distMatrix.setValue(i,j,overlap);
                }
            }
        }
        return distMatrix;
    }    
        
    /**
     * Prints the object
     **/
    public String toString(){
        String clusteringName = getName();
        String res="**************** Clustering name: "+clusteringName+" ********************\n";
        res += "#clusters: "+this.getSize()+"\n";
        for (int i=0; i<this.getSize(); i++){
            res += (getPattern(i)).toString();
        }
        res +="************************************";
        return res;
    }       
    public int getID(){
        return ID;
    }
    public void setID(int tid){
        ID = tid;
    }
  
    /* -- functions that all derived classes should specify -- */
    public String getType(){
        return "Clustering";
    }
    public  Class getAggregationtype(){
        return null;
    }
    public  Class getMatchtype(){
        return null;
    }
    protected double getScoreMeasure(panda.types.Pattern p1){
        return 1.0;
    }
    public double getScore(panda.types.Pattern p1)throws panda.types.IllegalTypeException,panda.dissimilarity.ScoreException{
        return -1.0;
    }

}
