/**
 * <p>Title: ClusterInstances</p>
 * @author Eirini Ntoutsi
 * @version 1.0
 */
package utils;
import java.util.*;

public class ClusterInstances {
    Vector instances; //a vector of NumericInstance objects
    private int numOfAttributes ; // the dimensionality

    //the constructor
    public ClusterInstances(Vector theInstances) {
        instances = theInstances;
        numOfAttributes = ((NumericInstance)instances.get(0)).getNumOfAttributes();
    }

    //the constructor
    public ClusterInstances(Vector theInstances, int attributesNum) {
        instances = theInstances;
        numOfAttributes = attributesNum;
    }
    //returns the number of instances
    public int getInstancesCnt(){
        return instances.size();
    }
    //returns the instances
    public Vector getInstances(){
        return instances;
    }

    //returns the number of attributes
    public int getNumOfAttributes(){
        return numOfAttributes;
    }
   

        
    //returns the instance at pos
    public NumericInstance getInstance(int pos){
        return (NumericInstance)this.instances.get(pos);
    }
    /*
     *finds the overlap of instances of this set with another set S2
     */
    public double overlap(ClusterInstances S2){
        double overlap = 0.0;
        int commonInstances = 0;
        for (int i=0; i <this.getInstancesCnt(); i++){
            NumericInstance first = this.getInstance(i);
            for (int j=0; j <S2.getInstancesCnt(); j++){
                NumericInstance second = S2.getInstance(j);
                if (first.getInstanceID() == second.getInstanceID())
                    commonInstances ++;
            }
        }
        int numOfThisInstances = this.getInstancesCnt();
        if (numOfThisInstances>0)
            overlap = (double) commonInstances/ numOfThisInstances;
        return overlap;
    }

   
    /**
     *Returns the number of common instances between this and another set S2
     ***/
    public int numOfCommonInstances(ClusterInstances S2){
        int commonInstancesCnt = 0;
        for (int i=0; i <this.getInstancesCnt(); i++){
            NumericInstance first = this.getInstance(i);
            for (int j=0; j <S2.getInstancesCnt(); j++){
                NumericInstance second = S2.getInstance(j);
                if (first.getInstanceID() == second.getInstanceID())
                    commonInstancesCnt ++;
            }
        }
        return commonInstancesCnt;
    }

    
    /**
     *Find the sum square distance of the instances from a given centroid 
     **/
    public double SumSquareDistance(NumericInstance centroid){
        double res = 0.0;
        for (int i=0; i<this.getInstancesCnt();i++){
            res += utils.Functions.SSQDistance(
                    centroid.getInstanceValues(),this.getInstance(i).getInstanceValues());
        }
        return res;
    }

    
    public int getPosWithinVector(Vector instances, int id){
        int res =-1;
        for (int i=0;i<instances.size();i++){
            if (((NumericInstance)(instances.get(i))).getInstanceID()==id){
                res =i;
                break;
            }
        }
        return res;
    }
    
    
   
    
    
}
