/**
 * <p>Title: Functions</p>
 * <p>Description:  functions</p>
 * @author Eirini Ntoutsi
 * @version 1.0
 */
package utils;
import java.util.*;
import java.io.*;

public class Functions {    
    /**
     * Returns the euclidean distance between two vectors
     **/
    public static double EuclideanDistance(Vector A, Vector B){
        double res = 0.0;
        if (A.size()!=B.size())
            return -1;
        for (int i=0; i<A.size(); i++){
            double attrValA =  new Double(A.get(i).toString()).doubleValue();                  
            double attrValB = new Double(B.get(i).toString()).doubleValue();                  
            res += Math.pow(Math.abs(attrValA - attrValB),2);
        }
        res = Math.sqrt(res);
        return res;
    }

    
   

 
    /**
     * Returns the sum square distance between two vectors
     **/
    public static double SSQDistance(Vector A, Vector B){
        double res = 0.0;
        if (A.size()!=B.size())
            return -1;
        for (int i=0; i<A.size(); i++){
            double attrValA = ((Double)A.get(i)).doubleValue();
            double attrValB = ((Double)B.get(i)).doubleValue();
            res += Math.pow(Math.abs(attrValA - attrValB),2);
        }
        return res;
    }
    
   
    
        
    //Returns the contents of an array
    public static String printArray(int[] ar){
        String str="";
        for (int i=0;i<ar.length;i++){
            str += ar[i]+"\n";
        }
        return str;
    }
 
    
    //Save into file
    public static void toFile(String path, String fileName, StringBuffer contents){
        try {
            OutputStream os = new FileOutputStream(path+fileName);
            DataOutputStream dos = new DataOutputStream(os);
            OutputStreamWriter bw = new OutputStreamWriter(dos);
            bw.write(contents.toString());
            bw.flush(); bw.close(); os.close();
        }
        catch (Exception e){System.out.println(e.toString());}
    }
}//end of file
