/**
 * @author Eirini Ntoutsi
 * @version 1.0
 */
package utils;

public class MMatrix {
    private double [][] values =new double[1][1];//values
    private String [] rowsLabels =new String[1];//rows labels
    private String [] colsLabels =new String[1];//columns labels

    /**
     * the constructor
     **/
    public MMatrix(int numOfColumns, int numOfRows, double initValue){
       this.values = new double[numOfRows][numOfColumns];
       this.rowsLabels = new String[numOfRows];
       this.colsLabels = new String[numOfColumns];
       //initialize all
       for (int i=0; i<numOfRows; i++){
           rowsLabels[i] = "";
           colsLabels[i] = "";
           for (int j = 0; j < numOfColumns; j++)
               values[i][j] = initValue;
       }
   }
    /**
     * another constructor
     **/
    public MMatrix(double theMatrix[][], String theRowsLabels[], String theColsLabels[]){
        values = theMatrix;
        rowsLabels = theRowsLabels;
        colsLabels = theColsLabels;
    }

    //get row label at a specific pos
    public int getRowLabelPos(String rowLabel){
        int resPos = -1;
        for (int i=0; i<rowsLabels.length; i++){
            if (rowsLabels[i].equals(rowLabel)) //if it is the same label
                resPos = i;
        }
        return resPos;
    }

    
    //get column label at a specific pos
    public String getColumnLabelAt(int colNum){
        return colsLabels[colNum];
    }

    //get column label at a specific pos
    public int getColumnLabelPos(String colLabel){
        int resPos = -1;
        for (int i=0; i<colsLabels.length; i++){
            if (colsLabels[i].equals(colLabel)) //if it is the same label
                resPos = i;
        }
        return resPos;
    }



    //get value at specific pos
    public double getValueAtPositions(int rowNum, int colNum){
        return values[rowNum][colNum];
    }

    //get value at specific pos
    public double getValueForLabels(String rowLabel, String colLabel){
        int rowPos = getRowLabelPos(rowLabel);
        int colPos = getColumnLabelPos(colLabel);
        return getValueAtPositions(rowPos,colPos);
    }

    //set value at specific pos
    public void setValue(int rowNum, int colNum, double val){
        values[rowNum][colNum] = val;
    }
    //get number of rows
    public int getNumOfRows(){
        return values.length;
    }
    //get number of columns
    public int getNumOfColumns(){
        return values[0].length;
    }
    //initialize matrix values
    public void initializeValues(double initValue){
        for (int i=0; i<this.getNumOfRows(); i++)
           for (int j=0; j<this.getNumOfColumns(); j++)
               values[i][j] = initValue;
   } 
}