/**
 * @author Eirini Ntoutsi
 * @version 1.0
 */
package utils;
import java.util.*;
public class NumericInstance {
    int instanceID; //the ID of the instance
    Vector instanceValues; //the value of each attribute for this instance
    String instanceClass; //the class of the instance
    int instanceCluster;// the ID of the cluster to which it is assigned
    
    /**
     *A constructor
     **/
    public NumericInstance(int id, Vector values) {
        instanceID = id;
        instanceValues = values;
        instanceClass="";
        instanceCluster=-1;
    }
    /**
     *Another constructor
     **/
    public NumericInstance(int id, Vector values, String clas,int clusterID) {
        instanceID = id;
        instanceValues = values;
        instanceClass = clas;
        instanceCluster = clusterID;
    }
   /**
    *Returns the id of the instance
    **/
    public int getInstanceID(){
        return instanceID;
    }
    /**
     *Returns the values of the instance 
     **/
    public Vector getInstanceValues(){
        return instanceValues;
    }
    /**
     *Returns the number of attributes describing the instance
     **/
    public int getNumOfAttributes(){
        return instanceValues.size();
    }
    /**
     *Returns the instance value for a specific attribute
     **/
    public double getInstanceValue(int j){
        return ((Double)instanceValues.get(j)).doubleValue();
    }
    /**
     *Returns the class label of an instance
     **/
    public String getInstanceClass(){
        return instanceClass; 
    }
    /**
     *Returns the cluster ID to which this instance has been assigned
     **/
    public int getInstanceClusterID(){
        return instanceCluster; 
    }
    
    public void setInstanceClusterID(int newClusterID){
        this.instanceCluster = newClusterID;
    }
    
}
