#include <time.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <iostream>
#include "List.cpp"
#include <string.h>
#include <assert.h>

#define N 1000           //document number
#define M 100            // mobile user number
#define C 300            // mobile cache size
#define cls 5
#define BN  1500
#define bup 64          // uplink message bytes
//#define bp  1024        // packet bytes
#define bdn 64          // downlink invalidation or validation message size.
#define W   1250          // bandwidth (bps)

double cal_zipf_coeff(int n, double q);
double  zipf=1.0;
double  coeff=cal_zipf_coeff(N, zipf);
double  runtime=0.;
double  endtime=100000.;
//double  slpwk=500.;
//double  slprate=0.9;
//double  update=1000.;
double  schtime=0.;

/*************************************************
Moblie User cache data structure
*************************************************/
struct mcachdata { int doc_id; short flag; double tim; /* LFU By Lana */ int accessnbre;};
// flag--0, valid data -- 1 only data title 
//    -- 2, uncertain status.

/**************************************************
Scheduling Queue data structure
***************************************************/
struct queuedata 
{int doc_id; short flag; int size; double tim;}; 

/**************************************************
pending List data struct
**************************************************/
struct pending {int doc_id; short flag; short hit; double tim; };
//flag--0 waiting the data, cache with no such data or title, add it at head
//--1 waiting the data, cache with uncertain data.

/**************************************************
Timing List Data Strcture
**************************************************/
struct timingdata 
{double tim; double dlt; short flag; short mu_id; int doc_id;}; 
// flag--0 request for mu_id at tim for doc_id;
//     --1 update for document doc_id at tim, mu_id is 0;  

/****************************************************
calculate the Zipf distribution coeffice.
****************************************************/
double cal_zipf_coeff(int number, double q)
{
 double sum=0.,x,y;
 int i;
  
 for(i=1; i<=number; i++)
 { x=(double)i;
   sum+=1./pow(x,q); 
 }
 
 y=1./sum;

 return y;
}

/****************************************************
Random double number generator Function between 0 and 1.
***************************************************/
double get_random()
{
  //unsigned int xx;
  double y;
   
  y=(double)rand()/(double)RAND_MAX;
  // y=(double)xx/4999999.;

  return y;
}

/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
Next Request Generator.
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
double next_time(double arate)
{
   double  dice,tm;
   dice=get_random();
   if(dice==0.) { dice=10E-100;}
   tm=-log(dice)/arate;

   return tm;
}

/*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
 Mobile user cache class  cach class.
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*/

template <class DType>
class mcach
{
  public:
                mcach();
	        ~mcach();
                void GoToSleep();
                void WakeUp(int &h);
		void SetDocSize(int sz);
		int DocSize();
                int RealDocSize();
                void SetTitleSize(int sz);
                int  RealTitleSize();
                int TitleSize();
		void SetArate(double arate);
	        double Arate();
		bool AddDocAtHead(mcachdata data);
                bool AddPending(pending pend);
		int GetNxtDocId(int shift);
                bool IsDocFull();
                bool IsTitleFull();
		short RQuest(int &did,double tim,int shift, double &tm);
		void operator = (mcach & ch);
                short Lsten(mcachdata did, short &ht, double tm,double &dy);
                int  OutDocId();
                short  DocStatus(int docid);
                bool MuStatus();
                void ShowList();

    private:
		double  arv_rate;
		int docsize, titlesize, docnumb,titlenumb, outdocid;
                bool state;
		List<pending> lp;
		List<DType> lst;
};

template <class DType>
mcach<DType>::mcach()
{ 
 arv_rate=0.; docnumb=0; titlenumb=0; outdocid=0;
 docsize=0; titlesize=0; state=false; lst; lp;
}

template <class DType>
mcach<DType>::~mcach() 
{
  arv_rate=0; lst.kill(); lp.kill(); docnumb=0; titlenumb=0; 
  outdocid=0; titlesize=0; state=false; docsize=0; 
}

template <class DType>
void mcach<DType>::GoToSleep() {state=false;}

template <class DType>
void mcach<DType>::WakeUp(int &h) 
{ h=0;
  if(!lp.Empty()) 
  { lp.SetToHead();
    while(1) { lp.Remove(); h++;  if(lp.Empty()) { break; } }
  }
  
  if(!lst.Empty())
    {
      lst.SetToHead();
      while(1)
      {   if(lst.Access()->flag!=1) 
	  { lst.Access()->flag=2; }
          if(!lst.Fore()) { break; }
      } 
    }

    state=true;
}

template <class DType>
void mcach<DType>::SetDocSize(int sz) {docsize=sz;}

template <class DType>
int mcach<DType>::DocSize() {return docsize;}

template <class DType>
int mcach<DType>::RealDocSize() {return docnumb;}

template <class DType>
void mcach<DType>::SetTitleSize(int sz) {titlesize=sz;}

template <class DType>
int mcach<DType>::RealTitleSize() {return titlenumb;}

template <class DType>
int mcach<DType>::TitleSize() {return titlesize;}

template <class DType>
void mcach<DType>::SetArate(double arate) {arv_rate=arate;}

template <class DType>
double mcach<DType>::Arate() {return arv_rate;}

template <class DType>
int mcach<DType>::OutDocId() { return outdocid;}

template <class DType>
bool mcach<DType>::IsDocFull() 
{
 if(docnumb >= docsize) 
 return true; 
 else return false;
}

template <class DType>
bool mcach<DType>::IsTitleFull() 
{
  if(titlenumb >= titlesize)  {return true;} 
  else { return false;}
}

template <class DType>
bool mcach<DType>::AddDocAtHead(mcachdata data)
{ 
  mcachdata out;
  short fg=0;
 
  lst.EnQueue (data); docnumb+=(1+data.doc_id%cls);
  
  if(docnumb>docsize)
  { 
    lst.SetToTail();   out=*lst.Access();  
    while(docnumb>docsize) 
    { 
      if(out.flag==1) { lst.Remove(); titlenumb--;}
      else 
       { lst.Remove(); docnumb-=(1+out.doc_id%cls); }
      out=*lst.Access();  
    } 
  
    //  lst.EnQueue(data); docnumb++;
   outdocid=out.doc_id;   
 }

  return true;
}

template <class DType>	
int mcach<DType>::GetNxtDocId(int shift)
{
 int i,id=0;
 double sum=0., x,rid;
 
 rid = get_random();

 if(zipf>=0.) {
   for(i=0;i<N;i++)
   { 
      x=double(i+1);
      sum+=coeff/pow(x,zipf);
      if(rid<=sum) { break; }
      id++;
   } 
 }
 else {
  for(i=0;i<N;i++)
  {
    if(N<=100) { id=(int)(rid*N); }
    else {
      if(rid<=0.8) { id=(int)(rid/0.008); } 
      else { id=(int)(100+(rid-0.8)*(N-100.0)/0.2); } 
    } 
  }
 }

 id=(id+shift)%N;

 return id;
}		

template <class DType>
short mcach<DType>::DocStatus(int docid)
{
  mcachdata data;
  short flag=4;

  if(lst.Empty()) { return flag; }

  lst.SetToHead();
  data=*lst.Access();

  while(1)
    {
      if(data.doc_id==docid)
        { flag=data.flag; break; }
      if(!lst.Fore()) { break;}
      data=*lst.Access();
    }
  
  return flag;
}

template <class DType>
short mcach<DType>::RQuest(int &did, double tim,int shift, double &tm)
{ 
 int docid;
 short st;
 mcachdata mdata;
 pending pend;

 docid=GetNxtDocId(shift); 
 st=DocStatus(docid);
 did=docid;  tm=0.;

 if(st==0)
 {
   mdata=*lst.Access(); 

   lst.Remove(); lst.EnQueue(mdata);  
   
 }
 else if(st==1 || st==4)
 { 
   if(st==1) { lst.Remove(); titlenumb--; }
   pend.doc_id=docid; pend.flag=0; pend.hit=1; pend.tim=tim;
   AddPending(pend);  st=1;
 }
 else if(st==2 || st==3)
   { mdata=*lst.Access(); tm=mdata.tim;
     pend.doc_id=docid; pend.flag=1; pend.hit=1; pend.tim=tim;
     AddPending(pend);
     if(st==2) 
     { mdata.flag=3;}
   
 
 lst.Remove(); lst.EnQueue(mdata); 

 st=2;
   }
   
 return st;

}

template <class DType>
bool mcach<DType>::AddPending(pending pend)
{
   bool fg=false;
   pending pnd;

   if(lp.Empty()) { lp.EnQueue(pend); return true; }

   lp.SetToTail();  pnd=*lp.Access();

   while(1)
   {
     if(pnd.doc_id==pend.doc_id) 
     { pend.hit+=pnd.hit; 
       pend.tim-=(pend.tim-pnd.tim)*pnd.hit/(double)(pend.hit+pnd.hit); 
       *lp.Access()=pend; 
       fg=true; break; 
     }
     if(!lp.Back()) { break; }
     pnd=*lp.Access(); 
   }
  
   if(fg==false) { lp.EnQueue(pend); fg=true;}

   return fg;
}

template <class DType>
bool mcach<DType>::MuStatus()
{
  return state;
}

template <class DType>
void mcach<DType>::operator = (mcach &ch)
{ 
  docsize=ch.docsize; arv_rate=ch.arv_rate; titlesize=ch.titlesize; 
  lst=ch.lst; outdocid=ch.outdocid; docnumb=ch.docnumb; 
  titlenumb=ch.titlenumb; lp=ch.lp;
} 

template <class DType>
short mcach<DType>::Lsten(mcachdata data, short &hit,double tim, double &delay)
{
  mcachdata mdata;
  pending pend;
  short rtn=0, fg=0, flg=1;

  hit=0; delay=0.;
  switch (data.flag) {
  case (0): // broadcast valid data
   {  if(!lp.Empty()) {         
       lp.SetToHead(); pend=*lp.Access();
       while(1) {
        if(pend.doc_id==data.doc_id)
        { if(pend.flag==1) { fg=1; } //uncertain data is invalid.
	    hit=pend.hit;
            delay=(tim-pend.tim)*hit;
            lp.Remove(); rtn=1; 
            break; 
        }
         if(!lp.Fore()) { break; }
         pend=*lp.Access();
       }
     }

    if(rtn==1) {
       if(fg==1)
       {  if(!lst.Empty()) {  
            lst.AtHead(); 
            while(1) 
            { if(mdata.doc_id==data.doc_id )
	      { 
                if(mdata.flag!=1) {lst.Remove(); docnumb-=(1+mdata.doc_id%cls);
break;}
                else {lst.Remove(); titlenumb--; break; }   
              }
	      if(!lst.Fore()) {break; }
              mdata=*lst.Access(); /* LFU by lana */ mdata.accessnbre ++;
            }
	   }
       }
	
	   /* By Lana */
	   //data.AccessNbre++;  
	   //temp1 = data;
	   //if (temp1.AccessNbre > temp.AccessNbre) 
	   //{
		//   temp = temp1; 
	   //}
	  // AddDocAtHead(temp);

	   //if (!lst.Empty()) {
        //  lst.AtHead(); 
	     // temp = *lst.Access(); 
	      //while (lst.Fore()) 	
	       //   {
		    //     if ( lst.Access()->AccessNbre > temp.AccessNbre ) {temp = *lst.Access();} 
	         //  }
	    // AddDocAtHead(temp);
	     // }
	   /* By Lana */

		/* lst.SetAtTail(); MRU by lana */
       AddDocAtHead(data);
     } 
    else { 
       if(!lst.Empty()) {
         lst.SetToHead(); mdata=*lst.Access();
         while(1)
	  { 
            if(mdata.doc_id==data.doc_id) 
            { if(mdata.flag==1) 
              { titlenumb--; docnumb+=(1+data.doc_id%cls); 
	        if(lst.AtHead()) 
			  {	  
			   // fifo lst.Remove();  lst.EnQueue(data); 
			    }
		else { lst.Remove(); lst.Insert(data); } 
               
	        if(docnumb > docsize) {
		  lst.SetToTail();
                  while(docnumb>docsize) {
                    if(lst.Access()->flag!=1  ) 
                    {  docnumb-=(1+lst.Access()->doc_id%cls); lst.Remove(); }
                    else { lst.Remove(); titlenumb--; }
                  }
		 }/*if(doc*/
	      }
	      else 
              {  if(lst.AtHead()) 
			     { 	  	
					// fifo lst.Remove(); lst.EnQueue(data); 
				 } 				   					
			  else { lst.Remove(); lst.Insert(data); }
              } 
              break;
           }
           if(!lst.Fore()) { break; }
           mdata=*lst.Access();
          } 
        }
      }
     break;
   }
  case (1):  // IR broadcast
   {  if(lst.Empty()) { break; }
      lst.SetToHead();   mdata=*lst.Access(); 
      while(1) {
	if(mdata.doc_id==data.doc_id)
	{  if(mdata.flag!=1 ) 
	  {    docnumb-=(1+mdata.doc_id%cls); titlenumb++; 
	       if(lst.AtHead()) 
			  {	   
				 // fifo lst.Remove(); lst.EnQueue(data); 
			     }
               else { lst.Remove(); lst.Insert(data); }

	       if(titlenumb>titlesize) 
	       { lst.SetToTail();  
		 while(1) {
		   if(lst.Access()->flag==1) 
                   { lst.Remove(); titlenumb--; break; }
                   if(!lst.Back()) { break; }
                  }
	       }
	     }
	     break;
	}
       if(!lst.Fore()) { break; }
       mdata=*lst.Access();
      }
    break;
  }
  case (2):
  { // if(lp.Empty()) { break; }
    if(!lp.Empty()) {
      lp.SetToHead(); pend=*lp.Access();
      while(1) {
        if(pend.doc_id==data.doc_id) 
        { if(pend.flag==1) { fg=1; }  break; }
       
        if(!lp.Fore()) { break; }
        pend=*lp.Access();
      }
    } 
    
     if(!lst.Empty()) {
       lst.SetToHead();  mdata=*lst.Access(); 
       while(1) {
          if(mdata.doc_id==data.doc_id) {
	    if(mdata.flag==2 || mdata.flag==3) {
              if(mdata.tim>=data.tim) {
                  if(fg==1) {
                     hit=pend.hit; delay=(tim-pend.tim)*hit;
		     //  lst.Access()->flag=0; 
	             lp.Remove();
                     rtn=2;
	 	  }
                  lst.Access()->flag=0;
	      }
	      else { 
                docnumb-=(1+data.doc_id%cls); titlenumb++; data.flag=1;
pend.flag=0;
                if(lst.AtHead()) 
				{   
					// fifo lst.Remove(); lst.EnQueue(data); 
				  }
                else { lst.Remove(); lst.Insert(data); }
                if(fg==1) {
		  lp.Access()->flag=0;
		}

                if(titlenumb>titlesize) { lst.SetToTail();
	 	  while(1) {
	             if(lst.Access()->flag==1)
                     { lst.Remove(); titlenumb--; break; }
                   if(!lst.Back()) { break;} 
                  }
                }   
              }	
           }
           break;
         }
	 if(!lst.Fore()) { break; }
         mdata=*lst.Access();
       }
     }
    break;
   }
    case (3):  // set uncertain state 
   {  if(lst.Empty()) { break; }
      lst.SetToHead(); //cout<<" Extra sleep."<<endl;
      while(1) {
	if(lst.Access()->doc_id==data.doc_id)
	{  if(lst.Access()->flag==0 ) 
	  { lst.Access()->flag=2; }
	    break;
	}
       if(!lst.Fore()) { break; }
      }
    break;
  }
  }//end switch 

  return rtn;
 
}

template <class DType>
void mcach<DType>::ShowList()
{ 
    cout<<"Show the "<<" datalist:"<<endl;
    cout<<"Doc:"<<RealDocSize()<<" Title:"
        <<RealTitleSize()<<endl;
    int numb=0; mcachdata mdat;
     lst.SetToHead();
     while(1) { if(lst.Empty()) { break;} 
                  mdat=*lst.Access(); cout<<numb<<" ";
	            cout<<"doc_id "<<mdat.doc_id<<" tim "<<mdat.tim
                      <<" flag "<<mdat.flag<<endl;
                    if(!lst.Fore()) {break; }   numb++;
                 }

     cout<<"show the"<<" pend list:"<<endl;
     lp.SetToHead(); numb=0; pending pend;
      while(1) { if(lp.Empty()) { break;} 
                   pend=*lp.Access(); cout<<numb<<" "; numb++;
	           cout<<"doc_id "<<pend.doc_id<<" tim "<<pend.tim
		       <<" flag "<<pend.flag<<" hit"<<pend.hit<<endl;
                   if(!lp.Fore()) {break; }
               }
}
