/*
 * Decompiled with CFR 0.152.
 */
package DMAAdditions;

import DMAAdditions.DataFileParser;
import DMAAdditions.ItemList;
import DMAAdditions.LineDatabase;
import DMAAdditions.MFI;

public class DMAAdditions {
    public static void main(String[] args) {
        if (args.length != 4) {
            System.err.println("Please give arguments for [INITIAL DATASET PATH] [INITIAL SUPPORT] [ADDITION DATASET PATH] [ADDITION SUPPORT]");
            return;
        }
        String initialDataPath = args[0];
        int initialMinSupport = Integer.parseInt(args[1]);
        String additions = args[2];
        int additionMinSupport = Integer.parseInt(args[3]);
        int ortalama = 0;
        System.out.println("DYNAMIC MATRIX APRIORI");
        for (int ii = 0; ii < 1; ++ii) {
            ItemList itemIdList = new ItemList();
            LineDatabase db = new LineDatabase();
            DataFileParser df = new DataFileParser();
            df.Parse(initialDataPath, itemIdList, db);
            db.setNames();
            db.sortLineItemsByName();
            db.calculateSupport();
            itemIdList.sortItems();
            itemIdList.createSupportedList(db.getSupport());
            MFI mfi = new MFI(itemIdList.supportedList);
            mfi.support = initialMinSupport;
            mfi.firstScan(db.DBase);
            mfi.secondScan();
            long start = System.currentTimeMillis();
            LineDatabase yenidb = new LineDatabase();
            df.Parse(additions, itemIdList, yenidb);
            yenidb.setNames();
            yenidb.sortLineItemsByName();
            itemIdList.sortItems();
            itemIdList.createSupportedList(db.getSupport());
            mfi.support = additionMinSupport;
            mfi.update(yenidb.DBase, itemIdList.supportedList);
            mfi.calculateFreqs();
            System.out.println("Items: " + itemIdList.itemList.size());
            long end = System.currentTimeMillis();
            ortalama = (int)((long)ortalama + (end - start));
            System.out.println("Frequent itemsets: " + mfi.freqItems.size());
        }
        System.out.println("Update time: " + ortalama / 1);
    }
}

