/*
 * Decompiled with CFR 0.152.
 */
package DMAAdditionsDeletions;

import DMAAdditionsDeletions.DataFileParser;
import DMAAdditionsDeletions.ItemList;
import DMAAdditionsDeletions.LineDatabase;
import DMAAdditionsDeletions.MFI;

public class DMAAdditionsDeletions {
    public static void main(String[] args) {
        if (args.length != 6) {
            System.err.println("Please give arguments for [INITIAL DATASET PATH] [SUPPORT] [ADDITION DATASET PATH] [SUPPORT AFTER ADDITIONS] [DELETION DATASET PATH] [SUPPORT AFTER DELETIONS]");
            return;
        }
        String initialDataPath = args[0];
        int initialMinSupport = Integer.parseInt(args[1]);
        String additions = args[2];
        int additionMinSupport = Integer.parseInt(args[3]);
        String deletions = args[4];
        int deletionMinSupport = Integer.parseInt(args[5]);
        int ortalama = 0;
        System.out.println("DYNAMIC MATRIX APRIORI");
        for (int ii = 0; ii < 1; ++ii) {
            ItemList itemIdList = new ItemList();
            LineDatabase db = new LineDatabase();
            DataFileParser df = new DataFileParser();
            df.Parse(initialDataPath, itemIdList, db);
            db.setNames();
            db.sortLineItemsByName();
            db.calculateSupport();
            itemIdList.sortItems();
            itemIdList.createSupportedList(db.getSupport());
            MFI mfi = new MFI(itemIdList.supportedList);
            mfi.support = initialMinSupport;
            mfi.firstScan(db.DBase);
            mfi.secondScan();
            long start = System.currentTimeMillis();
            LineDatabase yenidb = new LineDatabase();
            df.Parse(additions, itemIdList, yenidb);
            yenidb.setNames();
            yenidb.sortLineItemsByName();
            itemIdList.sortItems();
            itemIdList.createSupportedList(db.getSupport());
            mfi.support = additionMinSupport;
            mfi.update(yenidb.DBase, itemIdList.supportedList);
            System.out.println("Items: " + itemIdList.itemList.size());
            LineDatabase silinecekler = new LineDatabase();
            df.Parse(deletions, itemIdList, silinecekler, true);
            silinecekler.setNames();
            silinecekler.sortLineItemsByName();
            itemIdList.sortItems();
            itemIdList.createSupportedList(db.getSupport());
            mfi.support = deletionMinSupport;
            mfi.deletionUpdate(silinecekler.DBase, itemIdList.supportedList);
            mfi.calculateFreqs();
            long end = System.currentTimeMillis();
            ortalama = (int)((long)ortalama + (end - start));
            System.out.println("Frequent itemsets (after deletion): " + mfi.freqItems.size());
        }
        System.out.println("Update time: " + ortalama / 1);
    }
}

