/*
 * Decompiled with CFR 0.152.
 */
package DMAAdditions;

import DMAAdditions.DBLine;
import DMAAdditions.FrequentItem;
import DMAAdditions.Item;
import DMAAdditions.MFILine;
import java.util.ArrayList;

class MFI {
    public ArrayList<Item> itemSet;
    public ArrayList<MFILine> lines;
    public ArrayList<FrequentItem> freqItems;
    public int support;
    private int sayac;

    MFI(ArrayList<Item> supportedList) {
        this.itemSet = new ArrayList<Item>(supportedList);
        this.lines = new ArrayList();
        this.freqItems = new ArrayList();
        MFILine ilk = new MFILine();
        ilk.mid = 1;
        for (int i = 0; i < this.itemSet.size(); ++i) {
            ilk.values.add(0);
        }
        this.lines.add(ilk);
        this.sayac = 1;
    }

    public void printMFI() {
        int i;
        System.out.print("   ");
        for (i = 0; i < this.itemSet.size(); ++i) {
            System.out.print(this.itemSet.get((int)i).name + " ");
        }
        System.out.println(" STE");
        for (i = 0; i < this.lines.size(); ++i) {
            this.lines.get(i).printLine();
        }
    }

    public void firstScan(ArrayList<DBLine> dBase) {
        for (int i = 0; i < dBase.size(); ++i) {
            boolean yok = true;
            for (int j = 1; j < this.lines.size(); ++j) {
                if (!dBase.get((int)i).itemString.equals(this.lines.get((int)j).itemString)) continue;
                ++this.lines.get((int)j).ste;
                yok = false;
                break;
            }
            if (!yok) continue;
            boolean enAzBiriVar = false;
            MFILine yeni = new MFILine();
            yeni.itemString = dBase.get((int)i).itemString;
            yeni.nameSortedString = dBase.get((int)i).nameSortedString;
            for (int k = 0; k < this.itemSet.size(); ++k) {
                String kon = this.itemSet.get((int)k).name;
                if (dBase.get((int)i).itemString.contains(kon)) {
                    yeni.values.add(1);
                    this.itemSet.get((int)k).mfiLastLine = this.sayac;
                    enAzBiriVar = true;
                    continue;
                }
                yeni.values.add(0);
            }
            if (!enAzBiriVar) continue;
            yeni.mid = ++this.sayac;
            this.lines.add(yeni);
        }
    }

    public void secondScan() {
        for (int i = 0; i < this.itemSet.size(); ++i) {
            int onceki = 0;
            for (int j = 1; j < this.lines.size(); ++j) {
                if (this.lines.get((int)j).values.get(i) != 1) continue;
                this.lines.get((int)onceki).values.set(i, this.lines.get((int)j).mid);
                onceki = j;
            }
        }
    }

    public void printFreqItems() {
        for (int i = 0; i < this.freqItems.size(); ++i) {
            this.freqItems.get(i).printFreqItem();
        }
    }

    public void calculateFreqs() {
        int i;
        this.freqItems.clear();
        int basla = 0;
        for (i = 0; i < this.itemSet.size(); ++i) {
            if (this.itemSet.get((int)i).count < this.support) continue;
            basla = i;
        }
        for (i = basla; i > 0; --i) {
            FrequentItem curr = new FrequentItem();
            curr.items.add(this.itemSet.get(i));
            curr.itemIds.add(i);
            curr.count = 0;
            this.calculateFreqs(curr, i - 1);
        }
    }

    private void calculateFreqs(FrequentItem curr, int i) {
        boolean test = true;
        if (i == 0) {
            test = false;
        }
        for (int j = i; j >= 0; --j) {
            FrequentItem c = new FrequentItem(curr);
            c.items.add(this.itemSet.get(j));
            c.itemIds.add(j);
            c.count = 0;
            if (!this.countFreqs(c) || !test) continue;
            this.calculateFreqs(c, j - 1);
        }
    }

    public boolean countFreqs(FrequentItem curr) {
        int satir = 0;
        boolean done = true;
        while (done) {
            int enBuyuk = this.lines.get((int)satir).values.get(curr.itemIds.get(0));
            boolean hepsiVar = true;
            for (int i = 0; i < curr.itemIds.size(); ++i) {
                int c = this.lines.get((int)satir).values.get(curr.itemIds.get(i));
                if (c > enBuyuk) {
                    enBuyuk = c;
                }
                if (c == 0) {
                    hepsiVar = false;
                }
                if (c != 1) continue;
                done = false;
            }
            if (hepsiVar) {
                curr.count += this.lines.get((int)satir).ste;
            }
            if (!done) continue;
            satir = enBuyuk - 1;
        }
        --curr.count;
        if (curr.count >= this.support) {
            this.freqItems.add(new FrequentItem(curr));
            return true;
        }
        return false;
    }

    void update(ArrayList<DBLine> dBase, ArrayList<Item> supportedList) {
        int i;
        int j;
        int yeniCount = 0;
        for (j = 0; j < supportedList.size(); ++j) {
            boolean yeniSup = true;
            for (int i2 = 0; i2 < this.itemSet.size(); ++i2) {
                if (!supportedList.get((int)j).name.equals(this.itemSet.get((int)i2).name)) continue;
                yeniSup = false;
            }
            if (!yeniSup) continue;
            this.itemSet.add(supportedList.get(j));
            ++yeniCount;
        }
        for (j = 0; j < this.lines.size(); ++j) {
            for (i = 0; i < yeniCount; ++i) {
                this.lines.get((int)j).values.add(0);
            }
        }
        for (int i3 = 0; i3 < dBase.size(); ++i3) {
            boolean yok = true;
            for (int j2 = 1; j2 < this.lines.size(); ++j2) {
                if (dBase.get((int)i3).nameSortedString.compareTo(this.lines.get((int)j2).nameSortedString) != 0) continue;
                ++this.lines.get((int)j2).ste;
                yok = false;
                break;
            }
            if (!yok) continue;
            MFILine yeni = new MFILine();
            yeni.itemString = dBase.get((int)i3).itemString;
            yeni.nameSortedString = dBase.get((int)i3).nameSortedString;
            for (int k = 0; k < this.itemSet.size(); ++k) {
                String kon = this.itemSet.get((int)k).name;
                if (dBase.get((int)i3).itemString.contains(kon)) {
                    yeni.values.add(1);
                    this.lines.get((int)this.itemSet.get((int)k).mfiLastLine).values.set(k, this.sayac + 1);
                    this.itemSet.get((int)k).mfiLastLine = this.sayac;
                    continue;
                }
                yeni.values.add(0);
            }
            yeni.mid = ++this.sayac;
            this.lines.add(yeni);
        }
        ArrayList<Integer> mapping = new ArrayList<Integer>();
        for (i = 0; i < supportedList.size(); ++i) {
            for (int j3 = 0; j3 < this.itemSet.size(); ++j3) {
                if (supportedList.get((int)i).name.compareTo(this.itemSet.get((int)j3).name) != 0) continue;
                mapping.add(j3);
            }
        }
        for (i = 0; i < this.lines.size(); ++i) {
            ArrayList<Integer> temp = new ArrayList<Integer>(this.lines.get((int)i).values);
            this.lines.get((int)i).values.clear();
            for (int j4 = 0; j4 < mapping.size(); ++j4) {
                this.lines.get((int)i).values.add(temp.get((Integer)mapping.get(j4)));
            }
        }
        this.itemSet.clear();
        this.itemSet.addAll(supportedList);
    }

    void deletionUpdate(ArrayList<DBLine> dBase2, ArrayList<Item> supportedList) {
        int i;
        int j;
        for (int k = 0; k < dBase2.size(); ++k) {
            boolean yok = true;
            for (j = 1; j < this.lines.size(); ++j) {
                if (dBase2.get((int)k).nameSortedString.compareTo(this.lines.get((int)j).nameSortedString) != 0) continue;
                --this.lines.get((int)j).ste;
                yok = false;
                break;
            }
            if (!yok) continue;
            System.err.println("The line to be deleted does not exist in the database.");
            break;
        }
        ArrayList<Integer> mapping = new ArrayList<Integer>();
        for (i = 0; i < supportedList.size(); ++i) {
            for (j = 0; j < this.itemSet.size(); ++j) {
                if (supportedList.get((int)i).name.compareTo(this.itemSet.get((int)j).name) != 0) continue;
                mapping.add(j);
            }
        }
        for (i = 0; i < this.lines.size(); ++i) {
            ArrayList<Integer> temp = new ArrayList<Integer>(this.lines.get((int)i).values);
            this.lines.get((int)i).values.clear();
            for (int j2 = 0; j2 < mapping.size(); ++j2) {
                this.lines.get((int)i).values.add(temp.get((Integer)mapping.get(j2)));
            }
        }
        this.itemSet.clear();
        this.itemSet.addAll(supportedList);
    }
}

