function  CP=AttributeRankChange(A1,A2)
% This function aclculate distortion value of CP 
% Input:
%        A1[n][d] is Initial data matrix 
%        A2[n][d] is Perturbed data Matrix by S_SSVD 
%        
% output:
%        CP represents the change of rank of the average value of the attributes
%----------------------------------------
[n,m]=size(A1);
AV1= AverageOfMatrix(A1);
AV2=AverageOfMatrix(A2);

%  compute rank of average matrix 
RAV1=RankOfElements(AV1);
RAV2=RankOfElements(AV2);

CP=0;
for i=1:m
    CP=CP+abs(RAV1(i,1)-RAV2(i,1));
end

CP=CP/m;




end



