function  CK=AttributeRankMaintanace(A1,A2)
% This function aclculate distortion value of CK 
% Input:
%        A1[n][d] is Initial data matrix 
%        A2[n][d] is Perturbed data Matrix by S_SSVD 
%        
% output:
%        CK represents the change of rank of the average value of the attributes
%----------------------------------------
[n,m]=size(A1);
AV1= AverageOfMatrix(A1);
AV2=AverageOfMatrix(A2);

% compute rank of average matrix 
RAV1=RankOfElements(AV1);
RAV2=RankOfElements(AV2);

ACK=0*ones(m);
CK=0;

for i=1:m
    if (RAV1(i,1)==RAV2(i,1))
        ACK(i)=1;
    end
end

for i=1:m
    CK=CK+ACK(i);
end

   CK=CK/m;

end

