function [tElapsed_ThinSVD,tElapsed_SSVD]=ComputationalCostOF_SVDMethods(A,ev,eu)
% This function Measure performance of SVD base methods using stopwatch timer
% Input:
%       A[n][m]      is an Initial data matrix 
%       ev           is Sparsification parameter of matrix V 
%       eu           is Sparsification parameter of matrix U
% output:
%        tElapsed_ThinSVD is the elapsed time output of Thin_SVD method 
%        tElapsed_SSVD is is the elapsed time output of SSVD method
%-----------------------------------------------
r=rank(A);
tic;
for i=1:r
   D=Thin_SVD(A,i);
   RE(i,1)=RelativeError(A,D);
   RP(i,1)=RankPosition(A,D);
   RK(i,1)=RankMaintanance(A,D);
   CK(i,1)=AttributeRankMaintanace(A,D);
   CP(i,1)=AttributeRankChange(A,D);
     
end
tElapsed_ThinSVD=toc;

tic;
for j=1:r
   D=Single_SVD(A,i,ev,eu);
   RE(j,1)=RelativeError(A,D);
   RP(j,1)=RankPosition(A,D);
   RK(j,1)=RankMaintanance(A,D);
   CK(j,1)=AttributeRankMaintanace(A,D);
   CP(j,1)=AttributeRankChange(A,D);
     
end
tElapsed_SSVD=toc;

end
