function [WRE,WRP,WRK,WCK,WCP]=ComputeDistortionMetrics(B,D,W,SelIndex,RemIndex)

% This function  Calculate distortion amount of FS-SSVD method 
%
%Input:
%        B[n][d]           is data matrix that contains NSF selected features
%        D[n][d]           is Perturbed data Matrix of B by FS-SSVD method 
%        W[m][1]           is an Array of privacy levels of features
%        SelIndex [1][d]   is a sorted array of  selected features indices  
%        RemIndex [1][m-n] is an array of removed features indices 
% output:
%        WRE is Weighted Relative Error
%        WRP is Weighted Rank Position 
%        WRK is Weighted Rank Maintenance
%        WCP is Weighted Feature Rank Change 
%        WCK is weighted Feature Rank Maintenance.
%------------------------------------------

% Normalize the array of privacy levels of features
 Normweight= OSumNormalization(W);

%-------------------------------------------

WS_SF=0;   % sum of normalized weights of privacy of the selected superior features
for i=1:size(SelIndex,2)
    WS_SF=WS_SF+Normweight(SelIndex(i));
end
%-------------------------------------------

WS_RF=0;   % sum of normalized weights of privacy of the removed features
for i=1:size(RemIndex,2)
    WS_RF=WS_RF+Normweight(RemIndex(i));
end
%-------------------------------------------
% Calculate distortion metrics
WRE=WeightedRelativeError(B,D,WS_SF,WS_RF);
WRP=WeightedRankPosition(B,D,WS_SF,WS_RF);
WRK=WeightedRankMaintanance(B,D,RemIndex);
WCK=WeightedAttributeRankMaintanace(B,D,RemIndex);
WCP=WeightedAttributeRankChange(B,D,WS_SF,WS_RF);
%---------------------------------------------   
end