function [WRE,WRP,WRK,WCK,WCP]=FS_SSVD_Method_AllSetsOfPrivacyLevels (A,ev,eu,W,C,R,NSF)

% In this function by applying the FS-SSVD method,matrix containing selected 
% features will be perturbed and then amount of created distortion is calculated. 
%
% Input:
%       A[n][m]      is an Initial data matrix 
%       ev           is Sparsification parameter of matrix V 
%       eu           is Sparsification parameter of matrix U
%       W[m][10]     is an Array of privacy levels of features
%                    for any feature of A dataset, 10 weights [0,1] are assigned
%       C[n][1]      is Class Labels 
%       NSF          is number of selected features
%       R[1][m]      is an array of features index according of their rank 
%                    that obtained from Information gain algorithm by WEKA
% output:
%        WRE is Weighted Relative Error
%        WRP is Weighted Rank Position 
%        WRK is Weighted Rank Maintenance
%        WCP is Weighted Feature Rank Change 
%        WCK is weighted Feature Rank Maintenance.
%-----------------------------------------------
% Superior features selection 
[B,SelIndex,RemIndex]=FeatureSelection(A,R,NSF); 
%-------------------------------------------------
% Data Value Distortion Metrics
WRE=[];
WRP=[];
WRK=[];
WCK=[];
WCP=[];
%-------------------------------------------------
% SSVD perturbation process 
r=rank(B);
k=size(W,2);
for i=1:r
    
    % Do single-SVD Decomposition on B to compute a perturbed dataset 
    D=Single_SVD(B,i,ev,eu); 
    
    % Calculate data distortion metrics of FS-SSVD method for every set privacy levels 
    for j=1:k
       [WRE_W(j,1),WRP_W(j,1),WRK_W(j,1),WCK_W(j,1),WCP_W(j,1)]=ComputeDistortionMetrics(B,D,W(:,j),SelIndex,RemIndex);
    end
    % Calculate average value of distortion metrics for every k
    WRE(i,1)= mean (WRE_W);
    WRP(i,1)= mean(WRP_W);
    WRK(i,1)= mean(WRK_W);
    WCK(i,1)= mean (WCK_W);
    WCP(i,1)= mean(WCP_W);
    
    % Generate data perturbed matrix as an arff formatted file to use in Weka software for Calculate the mining accuracy  
    data={D C};
    SubWDBCArffWrite(data,SelIndex+1,['WDBC(56922)_Rank' int2str(i) '.arff']);
    
end
    % select one D as the final disturbed dataset 

end