function  [B,SelIndex,RemIndex]=FeatureSelection(A,R,NSF)
% In this function NSF of the superior features of matrix A is selected 
% through a feature selection algorithm   
% 
% Input:
%       A[n][m] is Initial data matrix 
%       R[1][m] is an array of features indices according of their rank 
%               that are obtained from Information gain algorithm by WEKA
%       NSF is number of selected features
% output:
%        B[n][d] is data matrix that contains NSF selected features
%        SelIndex is a sorted array of  selected features indices  
%        RemIndex is an array of removed features indices 
%-----------------------------
column=size(A,2); % M features
RemIndex=[];
B=[];

SelIndex=sort(R(1:NSF));
B=A(:,SelIndex(1));

m=1;
for i=1:column
    k=0;
    for j=1:NSF
        if(SelIndex(j)==i)
            k=1;
        end
    end
    if (k==0)
     RemIndex(m)=i;
     m=m+1;
    end
    
end

for i=2:NSF
    B=[B A(:,SelIndex(i))];
           
end