function  RK=RankMaintanance(A1,A2)
% This function aclculate distortion value of RK 
% Input:
%        A1[n][d] is Initial data matrix 
%        A2[n][d] is Perturbed data Matrix by S-SSVD 
%        
% output:
%         RK represents the percentage of elements that keep their ranks of
%         magnitude in each column after the distortion
%----------------------------------------
[n,m]=size(A1);
ARK=0*ones(n,m);

R1=RankOfElements(A1);
R2=RankOfElements(A2);
RK=0;

for i=1:n
    for j=1:m
        if (R1(i,j)==R2(i,j))
            ARK(i,j)=1;
        end
    end
end

for i=1:m
    for j=1:n
        RK=RK+ARK(j,i);
    end
end
RK=RK/(m*n);
        

end