function  RE=RelativeError(A1,A2)
% This function aclculate distortion value of RE 
% Input:
%        A1[n][d] is Initial data matrix 
%        A2[n][d] is Perturbed data Matrix by S-SSVD 
%        
% output:
%         RE is the ratio of the Frobenius norm of the difference of A2
%         from A1 to the Frobenius norm of A1
%----------------------------------------
% Frobenius norm of A =  norm(A,'fro') 

B=A1-A2;
RE=norm(B,'fro')/norm(A1,'fro');

end