function b=Single_SVD(data,k,ev,eu)

r=rank(data);
if k>r
    error('k must < matrix rank!');
end

[u,s,v]=svds(data,k);
[ru,cu]=size(u);
[rv,cv]=size(v);

 for i=1:ru
     for j=1:cu
         if abs(u(i,j))<eu
             u(i,j)=0;
         end
     end
 end
 
 for i=1:rv
     for j=1:cv
         if abs(v(i,j))<ev
             v(i,j)=0;
         end
     end
 end
 
 b=u*s*v';
 
end