function SubWDBCArffWrite(data,index,fileName)
% Writes the sub WDBC data as a arff formatted file.
% INPUT:    
%       fileName:       file name for writing data      
%       index:          index of attributes that will write
%       data:      		data for writing arff formatted(nInstan by nAttr)
%       
%--------------------------------
AllAttributeNames={'ID','radius1','radius2','radius3','texture1','texture2','texture3','perimeter1','perimeter2','perimeter3','area1','area2','area3','smoothness1','smoothness2','smoothness3','compactness1','compactness2','compactness3','concavity1','concavity2','concavity3','concavePoints1','concavePoints2','concavePoints3','symmetry1','symmetry2','symmetry3','fractalDimension1','fractalDimension2','fractalDimension3','diagnosis'};
AllAttributeTypes={'numeric','real','real','real','real','real','real','real','real','real','real','real','real','real','real','real','real','real','real','real','real','real','real','real','real','real','real','real','real','real','real','{M,B}'};
dataName='WisconsinDiagnosticBreastCancer ';
%---------------------------------
i
if isempty(index)
   index=[2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31];
end
%---------------------------------
M=size(index,2);
attributeName={};
attributeType={};
for i=1:M
    attributeName=[attributeName AllAttributeNames{index(i)}];
    attributeType=[attributeType AllAttributeTypes{index(i)}];
end
attributeName=[attributeName AllAttributeNames{32}];
attributeType=[attributeType AllAttributeTypes{32}];

[nInstance,nAttribute]= size(data{1});
format = [];
for i=1:nAttribute
   format = [format ' %6.4f'];
end
format = [format ' %s\n'];
%-------------------------------
fid = fopen(fileName,'w');          % open the file if exists otherwise create new
%-------------------------------

% Writing headings in the arff file format.
fprintf(fid,'%s %s\n','@relation',char(dataName));

for i=1:nAttribute+1
    fprintf(fid,'%s %s %s \n' ,'@attribute' ,char(attributeName{i}) ,char(attributeType{i}) );
end

fprintf(fid,'%s \n','@data');
%-------------------------------

% Data are space delimeted matrix
for i=1:nInstance
    fprintf(fid,format,data{1}(i,1:nAttribute),char(data{2}(i)));     
end
fclose(fid);

end



