function [RE,RP,RK,CP,CK]=ThinSVD_Method(A,C)
% In this function by applying the Thin-SSVD method,initial data matrix 
% will be perturbed and then amount of created distortion is calculated. 
%
% Input:
%       A[n][m]      is an Initial data matrix 
%       C[n][1]      is Class Labels 
% output:
%        RE is Relative Error
%        RP is Rank Position 
%        RK is Rank Maintenance
%        CP is Feature Rank Change 
%        CK is Feature Rank Maintenance.
%-----------------------------------------------
r=rank(A);
for i=1:r
   % Do Thin-SVD Decomposition on A to compute a perturbed dataset 
   D=Thin_SVD(A,i);
   
   % Calculate value of distortion metrics for every k

   RE(i,1)=RelativeError(A,D);
   RP(i,1)=RankPosition(A,D);
   RK(i,1)=RankMaintanance(A,D);
   CK(i,1)=AttributeRankMaintanace(A,D);
   CP(i,1)=AttributeRankChange(A,D);
    
   %generate data perturbed matrix as an arff formatted file to use in Weka software for Calculate the mining accuracy  
   
   index=[];
   data={D C};
   SubWDBCArffWrite(data,index,['WDBC(56930)_ThinSVD_Rank' int2str(i) '.arff']);
   
end
    % select one D as the final disturbed dataset 

end

