function  WCP=WeightedAttributeRankChange(A1,A2,WS_SF,WS_RF)
% This function  Calculate distortion value of WCP 
% Input:
%       A1[n][d] is Initial data matrix 
%       A2[n][d] is Perturbed data Matrix by FS-SSVD 
%       WS_SF is sum of normalized weights of privacy of the selected superior features
%       WS_RF is sum of normalized weights of privacy of the removed features 
% output:
%       WCP is Weighted Feature Rank Change  
%------------------------------------------
CP=AttributeRankChange(A1,A2);
WCP=CP+((WS_RF/WS_SF)*CP);

end