function  WCK=WeightedAttributeRankMaintanace(A1,A2,RemInd)
% This function  Calculate distortion value of WCK 
% Input:
%        A1 [n][d] is Initial data matrix 
%        A2 [n][d] is Perturbed data Matrix by FS-SSVD 
%        RemIndex  is an array of removed features indices 
% output:
%        WCK is Weighted Rank Position 
%---------------------------------------
CK=AttributeRankMaintanace(A1,A2);
   
NRF=size(RemInd,2); % number of Removed features 
if(NRF==0)
    WCK=CK;
else
  WCK=CK*(1/NRF);
end

end