function  WRK=WeightedRankMaintanance(A1,A2,RemIndex)
% This function calculate distortion value of WRK 
% Input:
%        A1[n][d] is Initial data matrix 
%        A2[n][d] is Perturbed data Matrix by FS-SSVD 
%        RemIndex is an array of removed features indices 
% output:
%        WRK is Weighted Feature Rank Maintenance 
%--------------------------------
RK=RankMaintanance(A1,A2);

NRF=size(RemIndex,2); % number of Removed features 
if(NRF==0)
    WRK=RK;
else
  WRK=RK*(1/NRF);
end

end