function  WRP=WeightedRankPosition(A1,A2,WS_SF,WS_RF)
% This function calculate distortion value of WRP 
% Input:
%       A1[n][d] is Initial data matrix 
%       A2[n][d] is Perturbed data Matrix by FS-SSVD 
%       WS_SF is sum of normalized weights of privacy of the selected superior features
%       WS_RF is sum of normalized weights of privacy of the removed features 
% output:
%       WRP is Weighted Rank Position 
%-----------------------------------------
RP=RankPosition(A1,A2);

WRP=RP+((WS_RF/WS_SF)*RP);

end   
