function  WRE=WeightedRelativeError(A1,A2,WS_SF,WS_RF)
% This function  Calculate distortion value of WRE 
% Input:
%        A1[n][d] is Initial data matrix 
%        A2[n][d] is Perturbed data Matrix by FS-SSVD 
%        WS_SF is sum of normalized weights of privacy of the selected superior features
%        WS_RF is sum of normalized weights of privacy of the removed features 
% output:
%         WRE is Weighted Relative Error
%----------------------------------------
RE=RelativeError(A1,A2); 

WRE=RE+((WS_RF/WS_SF)*RE);

end