# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Predict
                                 A QGIS plugin
 Predict urban evolution
                              -------------------
        begin                : 2012-12-17
        copyright            : (C) 2012 by Asma GHARBI
        email                : asma.gharbiii@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
# Import the PyQt and QGIS libraries
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from qgis.core import *
from qgis.gui import *
# Initialize Qt resources from file resources.py
import resources
#import shell
import commands
# Import the code for the dialog
from predictdialog import PredictDialog
#import the code from ui_predict file to use its variable
import ui_predict
import random
class Predict:  

    def __init__(self, iface):
        # Save reference to the QGIS interface
        self.iface = iface
        # create our GUI dialog
        self.dlg = PredictDialog()

    def initGui(self):
        # Create action that will start plugin configuration
        self.action = QAction(QIcon(":/plugins/predict/icon.png"), \
            "Predict urban evolution", self.iface.mainWindow())
        # connect the action to the run method
        QObject.connect(self.action, SIGNAL("triggered()"), self.run)
        #self.dlg.ui.checkBox.setCheckState(Qt.Unchecked)
        
      

        # Add toolbar button and menu item
        self.iface.addToolBarIcon(self.action)
        self.iface.addPluginToMenu("&Predict urban evolution", self.action)

    def unload(self):
        # Remove the plugin menu item and icon
        self.iface.removePluginMenu("&Predict urban evolution",self.action)
        self.iface.removeToolBarIcon(self.action)

    #the method of selecting the learning file

    def browse(self):
        pass

   


    # run method that performs all the real work
    def run(self):

        # create and show the dialog
        dlg = PredictDialog()
        # show the dialog
        dlg.show()
        result = dlg.exec_()
       # See if OK was pressed
        if result == 1:

          f= open("/home/gharbi/.qgis/python/plugins/Predict/path.txt", "r")
          lines=f.readline()
          n=len(lines)
          linex=lines.replace('\n','')
          nn=len(linex)
          y='java -cp /usr/share/java/weka.jar weka.associations.Apriori -t '+linex+' -N 300 -M 0.02 -T 1 -C 0.5'
          x = commands.getoutput(y)
          QMessageBox.information(None,"Extracted rules",x)
          f.close()
          f2= open("/home/gharbi/.qgis/python/plugins/Predict/Rules.txt", "w")
          f2.write(x)
          f2.close()
          #extract then save rules in the file Rules.txt
          f = open("/home/gharbi/.qgis/python/plugins/Predict/Rules.txt","r")
          f1 = open("/home/gharbi/.qgis/python/plugins/Predict/Frules.txt","w")
          lines=f.readlines()
          rang=[' 1',' 2',' 3',' 4',' 5',' 6',' 7',' 8',' 9','10','11','12','13','14','15','16','17','18','19','20','21','22','23','24','25','26','27','28','29','30','31','32','33','34','35','36','37','38','39','40','41','42','43','44','45','46','47','48','49','50','51','52','53','54','55','56','57','58','59','60','61','62','63','64','65','66','67','68','69','70','71','72','73','74','75','76','77','78','79','80','81','82','83','84','85','86','87','88','89','90','91','92','93','94','95','96','97','98','90','91','92','93','94','95','96','97','98','99']
          rang1=['  1','  2','  3','  4','  5','  6','  7','  8','  9']
          for v in lines:
             z=v[:2] 
             zz=v[:3] 
             if z in rang:
                f1.write(v)
             if zz in rang1:
                f1.write(v) 
          f1.close()
          f.close()
          
#save premises and conclusions of the extracted rules in two separate files Premis.txt and Conclusion.txt
          f2 = open("/home/gharbi/.qgis/python/plugins/Predict/Frules.txt","r")
          f3 = open("/home/gharbi/.qgis/python/plugins/Predict/Premise.txt","w")
          f4 = open("/home/gharbi/.qgis/python/plugins/Predict/Conclusion.txt","w")
          lines1=f2.readlines()
          cmpt=1
          for chaine1 in lines1:
             x1=chaine1.split('==>')
             for i1 in x1:
                if x1.index(i1)==0:  
                  f3.write(i1+'\n')
                else:
                  linex=i1.replace('\n','')
                  f4.write(linex+'\n')
             cmpt=cmpt+1
          f4.close()
          f3.close()
         
  #select rules with a single premis and a single conclusion
#Then extract the premises and the conclusions of each rule
          print "***************************\n"
          f5 = open("/home/gharbi/.qgis/python/plugins/Predict/Premise.txt","r")
          NmbrList=[]
          ListPremis=f5.readlines()
          for premise in ListPremis:
              cmpt1=0
              y1=premise.split(' ')
              for j1 in y1:
                 if j1.find("=")!=-1:
                    cmpt1=cmpt1+1
              NmbrList.append(cmpt1)#Put in a list the number of premises for each rule 
          print NmbrList
          f5.close()
          f5 = open("/home/gharbi/.qgis/python/plugins/Predict/Conclusion.txt","r")
          NmbrList1=[]
          ListConclusion=f5.readlines()
          for Conclusion in ListConclusion:
              cmpt1=0
              y1=Conclusion.split(' ')
              for j1 in y1:
                 if j1.find("=")!=-1:
                    cmpt1=cmpt1+1
              NmbrList1.append(cmpt1)#Put in a list the number of conclusions for each rule
          print NmbrList1
          f5.close() 
#*****************************************************************************
          f5 = open("/home/gharbi/.qgis/python/plugins/Predict/Premise.txt","r")
          f8 = open("/home/gharbi/.qgis/python/plugins/Predict/Premise1.txt","w")
          ListPremis=f5.readlines()
          f6= open("/home/gharbi/.qgis/python/plugins/Predict/Conclusion.txt","r")
          f9= open("/home/gharbi/.qgis/python/plugins/Predict/Conclusion1.txt","w")
          ListConclusion=f6.readlines()
          List=[]
          j=0

          for x in NmbrList:
             if NmbrList[j]==1 and NmbrList1[j]==1: #Put in a list the number the number of rules with  
                List.append(j)                     #a single premise and a single conclusion
             j=j+1
          print List
          for x in List:
             f8.write(ListPremis[x])
             f9.write(ListConclusion[x])
        
          f6.close()
          f5.close()
          f8.close()
          f9.close()
#**********************************************************************************
          #remove the unwanted characters in both premises and conclusions.
          f5=open("/home/gharbi/.qgis/python/plugins/Predict/Premise1.txt","r")
          ListPremis=f5.readlines()
          f5.close()
          f6=open("/home/gharbi/.qgis/python/plugins/Predict/Premise1.txt","w")
          for Premise in ListPremis:
              y1=Premise.split(' ')
              for j1 in y1:
                  if j1.find("=")!=-1:
                     j2=j1.replace('=1',"")
                     f6.write(j2)
                     f6.write('\n')

           
          f6.close()
          f5=open("/home/gharbi/.qgis/python/plugins/Predict/Conclusion1.txt","r")
          ListConclusion=f5.readlines()
          f5.close()
          f6=open("/home/gharbi/.qgis/python/plugins/Predict/Conclusion1.txt","w")
          for Conclusion in ListConclusion:
             y1=Conclusion.split(' ')
             for j1 in y1:
                if j1.find("=")!=-1:
                   j2=j1.replace('=1',"")
                   f6.write(j2)
                   f6.write('\n')
          f6.close()
#chercher le suffix de la première chaine(prémis) dans la deuxième(conclusion) à partir de 
#Look for a suffix of the premise in the conclusion starting from the first position in order to 
#extract an interesting rule
          #******************************************************************************
          #******************************************************************************

          lchC=[]
          f5=open("/home/gharbi/.qgis/python/plugins/Predict/Conclusion1.txt","r")
          ListConclusion=f5.readlines()
          for Conclusion in ListConclusion:
              lchC.append(Conclusion.replace('\n',""))
          f5.close()
          print lchC

          f5=open("/home/gharbi/.qgis/python/plugins/Predict/Premise1.txt","r")
          f6=open("/home/gharbi/.qgis/python/plugins/Predict/FPremise1.txt","w")
          f7=open("/home/gharbi/.qgis/python/plugins/Predict/FConclusion1.txt","w")
          ListPremis=f5.readlines()
          j=0

          for Premise in ListPremis:
              #v=Premise[len(Premise)-3:]
              jj=0
              Lok=[]
              print "********"
              vv=Premise.replace('\n',"")
              if len(lchC[j])>=len(vv):
                for v in range(len(vv)):
                   ChP=vv[len(vv)-v-1:]
                   ch=lchC[j]
                   print ChP+" --"+str(v)+" "+ch[0:v+1]
                   ch1=ch[0:v+1]
                   if ChP==ch1:
                      print 'Ok'
                      jj=jj+1
                      print jj
                      print ChP
                      Lok.append(ChP)
                      print Lok
                      print "la taille de: "+str(len(Lok))
                   else:
                      print 'nok'
              if len(Lok)==1:
                    f7.write(ch[len(ch1):])
                    f7.write('\n')
                    f6.write(Premise)
              if len(Lok)>1:
                    f7.write(ch[len(Lok[len(Lok)-1]):])
                    f7.write('\n')
                    f6.write(Premise)
              j=j+1
          f5.close()
          f7.close()
          f6.close()



          

          


#*********************************************************************       

          
          vlayer=self.iface.addVectorLayer("/home/gharbi/.qgis/python/plugins/Predict/Data/frontierePlaine.shp", "FrontiereLaPlaine", "ogr")
          vlayer=self.iface.addVectorLayer("/home/gharbi/.qgis/python/plugins/Predict/Data/UrbanObjects1975.shp", "LaPlaine1975", "ogr")
          #definir la couche concerné (la couche activé)
          f6=open("/home/gharbi/.qgis/python/plugins/Predict/CurrentFunction.txt","w")
          macouche = self.iface.activeLayer()
          #select_tout(macouche)
          #selectionner tout les objets
          macouche.select([])
          macouche.setSelectedFeatures([obj.id() for obj in macouche])
          #afficher l'attribut fonction de tour les objets
          for elem in macouche.selectedFeatures():
              attributs=elem.attributeMap()
              mon_attribut=attributs[2]
              print mon_attribut.toString()
              Cfun=mon_attribut.toString()
              f6.write(Cfun)
              f6.write('\n')
          
          f6.close()

          f5=open("/home/gharbi/.qgis/python/plugins/Predict/CurrentFunction.txt","r")
          f6=open("/home/gharbi/.qgis/python/plugins/Predict/FPremise1.txt","r")
          FListPremis=f6.readlines()
          f7=open("/home/gharbi/.qgis/python/plugins/Predict/FConclusion1.txt","r")
          f8=open("/home/gharbi/.qgis/python/plugins/Predict/FutureFunction.txt","w")
          FFListConclusion=f7.readlines()
          ListCurrentFunction=f5.readlines()
          jjj=0
          TableauCodage=[["Garage","a"],["Batiment-Industriel","c"],["Equipement-de-sante","e"],["Ecole","h"],["Societe","j"],["Batiment-bureau","L"], ["Groupe-scolaire","n"],["Batiment-residentiel","q"],["Bibliotheque","s"],["Mediatheque","v"],["Asile","y"],["Agence-Postal","A"],["Agence-bancaire","D"],["Etablissement-administrative","H"],["Organisme-de-recherche","K"],["Etablissement-d-eseignement-secondaire","N"],["Complex-sportif","P"],["Hotel","b"],["Point-de-vente","d"],["Depot","g"],["Studio","i"],["Espace-spectacle-reunion","k"],["Centre-d-appel","m"],["Ecole-maternelle","o"],["Terrain-de-jeux","r"],["Poste-de-police","t"],["Creche-municipal","x"],["Gendarmerie","z"],["Restaurant","C"],["Etablissement-d-enseignement-superieur","G"],["Etablissement-institutionelle","J"],["Siege-d-organisation","M"],["Stade","O"],["Activite-legere","E"],["Lieu-De-Culte","Q"],["Cimetiere","R"],["Infrastructure-Transport","S"]]
          for Cf in ListCurrentFunction:
             UncodedFunction=Cf.replace('\n',"")
             print UncodedFunction
             jjj=jjj+1
             print jjj
             for i in TableauCodage :
               for j in i : 
                 if j==UncodedFunction:
                   CodedCurrFun=i[1]
                   print CodedCurrFun
                   jFLP=0
                   Fn=0
                   listeFutureFun=[]
                   for x in FListPremis:
                     if x.replace('\n',"")==CodedCurrFun:
                        Fn=Fn+1
                        jx=jFLP
                        print FFListConclusion[jx]
                        listeFutureFun.append(FFListConclusion[jx].replace("\n",""))   
                     jFLP=jFLP+1    
    
             print Fn
             print listeFutureFun
             x="-".join(listeFutureFun)
             print x
             f8.write(x+"\n")

          f5.close()
          f6.close()
          f7.close()
          f8.close()
          f=[]
          f8=open("/home/gharbi/.qgis/python/plugins/Predict/FutureFunction.txt","r")
          ListFutureFunction=f8.readlines()
          f8.close()
          f8=open("/home/gharbi/.qgis/python/plugins/Predict/FutureFunction.txt","w")
          for z in ListFutureFunction:
             f=[]
             for x in z:
               for i in TableauCodage :
                  for j in i : 
                    if j==x:
                      CodedFutureFun=i[0]
                      f.append(i[0])
             print f
             y=",".join(f)
             f8.write(y+"\n")
          f8.close()
          f8=open("/home/gharbi/.qgis/python/plugins/Predict/FutureFunction.txt","r")
          FutureFunctionQgis=f8.readlines()
          caps = macouche.dataProvider().capabilities()
          for elem in macouche.selectedFeatures():
             attributs=elem.attributeMap()
             geom= elem.geometry()
             print FutureFunctionQgis[elem.id()]
             if caps & QgsVectorDataProvider.ChangeAttributeValues:
                 if len(FutureFunctionQgis[elem.id()])==1:
                      mon_attribut=attributs[2]
                      attrs = { 6 : QVariant(mon_attribut)}
                      macouche.dataProvider().changeAttributeValues({elem.id() : attrs })
                      
                 else:
                         

                      attrs = { 6 : QVariant(FutureFunctionQgis[elem.id()])}
                      macouche.dataProvider().changeAttributeValues({elem.id() : attrs })
                      Ff=FutureFunctionQgis[elem.id()].split(',')
                      attributs=elem.attributeMap() 
                      macouche.startEditing()
                      for f in Ff:
                          macouche.startEditing()
                          feat = QgsFeature()
                          feat.addAttribute(0,elem.id())
                          feat.addAttribute(7,f)
                          feat.setGeometry(QgsGeometry.fromPoint(QgsPoint(random.uniform(geom.asPoint().x()+10,geom.asPoint().x()+50),random.uniform(geom.asPoint().y()+10,geom.asPoint().y()+50))))
                          macouche.addFeatures([feat])
              
                 
                    
               

    
   

    
     
    

          



























          
               

   


           
