/*
 * Decompiled with CFR 0.152.
 */
package com.ethon.mode;

import java.awt.Color;

public class DataPoint {
    private double coord_X;
    private double coord_Y;
    private double weight = 1.0;
    private int radium = 1;
    private Color color = new Color(0, 0, 0);

    public DataPoint(double coord_X, double coord_Y, double weight, int radium, Color color) {
        this.coord_X = coord_X;
        this.coord_Y = coord_Y;
        this.weight = weight > 0.0 ? weight : 100.0;
        this.radium = radium > 0 ? radium : 1;
        this.color = color == null ? new Color(0, 0, 0) : color;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public int getRadium() {
        return this.radium;
    }

    public void setRadium(int radium) {
        this.radium = radium;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public double getCoord_X() {
        return this.coord_X;
    }

    public double getCoord_Y() {
        return this.coord_Y;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataPoint other = (DataPoint)obj;
        if (this.coord_X != other.coord_X) {
            return false;
        }
        return this.coord_Y == other.coord_Y;
    }

    public String toString() {
        return String.valueOf(this.coord_X) + "," + this.coord_Y + "," + this.weight + "," + this.radium + ",[" + this.color.getRed() + "," + this.color.getGreen() + "," + this.color.getBlue() + "]";
    }

    public DataPoint update(String str) {
        DataPoint dp = DataPoint.getNewPoint(str);
        double x = dp.getCoord_X();
        double y = dp.getCoord_Y();
        if (x >= 0.0) {
            this.coord_X = x;
        }
        if (y >= 0.0) {
            this.coord_Y = y;
        }
        this.weight = dp.getWeight();
        this.radium = dp.getRadium();
        this.color = dp.getColor();
        return this;
    }

    public static DataPoint getNewPoint(String str) {
        String[] array;
        if ((str = str.trim()).length() == 0) {
            return null;
        }
        double coord_X = -1.0;
        double coord_Y = -1.0;
        int radium = -1;
        double weight = 0.0;
        Color color = null;
        if (str.matches(".*\\[\\d+,\\d+,\\d+\\]")) {
            String colorStr = str.substring(str.indexOf("[") + 1, str.indexOf("]"));
            int r = Integer.parseInt(colorStr.substring(0, colorStr.indexOf(",")));
            int g = Integer.parseInt(colorStr.substring(colorStr.indexOf(",") + 1, colorStr.lastIndexOf(",")));
            int b = Integer.parseInt(colorStr.substring(colorStr.lastIndexOf(",") + 1, colorStr.length()));
            color = new Color(r, g, b);
            str = str.substring(0, str.indexOf("[") - 1);
        }
        if ((array = str.split(",")).length >= 2) {
            if (array[0].trim().length() != 0) {
                coord_X = Double.parseDouble(array[0].trim());
            }
            if (array[1].trim().length() != 0) {
                coord_Y = Double.parseDouble(array[1].trim());
            }
        }
        if (array.length >= 3 && array[2].trim().length() != 0) {
            weight = Double.parseDouble(array[2].trim());
        }
        if (array.length >= 4 && array[3].trim().length() != 0) {
            radium = Integer.parseInt(array[3].trim());
        }
        return new DataPoint(coord_X, coord_Y, weight, radium, color);
    }
}

