/*
 * Decompiled with CFR 0.152.
 */
package com.ethon.plugin;

import com.ethon.DataBase;
import com.ethon.mode.DataPoint;
import com.ethon.tools.CoordTransfer;
import com.ethon.tools.CounterUtil;
import com.ethon.tools.ImageGenerator;
import com.ethon.ui.DataField;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.JOptionPane;

public class Hasta {
    private int IFP;
    private double dx;
    private double dy;
    private double xmin;
    private double ymin;
    private double sigma;
    private Grid[][] steps;
    protected long start = System.currentTimeMillis();
    private int thread;
    private int K;
    private int[][] lookupTable;
    private BigGrid[][] grids;

    public Hasta(int K, int IFP) {
        double y;
        double x;
        DataPoint p;
        this.IFP = IFP;
        this.K = K;
        DataPoint[] points = DataBase.getInstance().getPoints();
        this.xmin = Double.MAX_VALUE;
        this.ymin = Double.MAX_VALUE;
        double xmax = Double.MIN_VALUE;
        double ymax = Double.MIN_VALUE;
        this.steps = new Grid[K][K];
        DataPoint[] dataPointArray = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            p = dataPointArray[n2];
            x = p.getCoord_X();
            y = p.getCoord_Y();
            if (this.xmin > x) {
                this.xmin = x;
            }
            if (this.ymin > y) {
                this.ymin = y;
            }
            if (xmax < x) {
                xmax = x;
            }
            if (ymax < y) {
                ymax = y;
            }
            ++n2;
        }
        this.dx = (xmax - this.xmin) / (double)K;
        this.dy = (ymax - this.ymin) / (double)K;
        this.sigma = Math.min(this.dx, this.dy);
        this.sigma *= (double)IFP;
        dataPointArray = points;
        n = points.length;
        n2 = 0;
        while (n2 < n) {
            p = dataPointArray[n2];
            x = p.getCoord_X();
            y = p.getCoord_Y();
            int xl = (int)Math.floor((x - this.xmin) / this.dx);
            int yl = (int)Math.floor((y - this.ymin) / this.dy);
            if (xl == K) {
                xl = K - 1;
            }
            if (yl == K) {
                yl = K - 1;
            }
            if (this.steps[xl][yl] == null) {
                this.steps[xl][yl] = new Grid();
            }
            this.steps[xl][yl].add(p);
            ++n2;
        }
        int x2 = 0;
        while (x2 < K) {
            int y2 = 0;
            while (y2 < K) {
                double xloc = this.xmin + this.dx / 2.0 + this.dx * (double)x2;
                double yloc = this.ymin + this.dy / 2.0 + this.dy * (double)y2;
                Grid grid = this.steps[x2][y2];
                if (grid == null) {
                    grid = new Grid();
                    grid.setCenter(xloc, yloc);
                    this.steps[x2][y2] = grid;
                }
                ++y2;
            }
            ++x2;
        }
        this.lookupTable = new int[K][K];
        int y3 = 0;
        while (y3 < K) {
            int x3 = 0;
            while (x3 < K) {
                this.lookupTable[x3][y3] = 0;
                ++x3;
            }
            ++y3;
        }
    }

    public void outputResultsInorder(File resultFile, ArrayList<Cluster> result) {
        DataPoint[] points = DataBase.getInstance().getPoints();
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(resultFile));
            DataPoint[] dataPointArray = points;
            int n = points.length;
            int n2 = 0;
            while (n2 < n) {
                DataPoint point = dataPointArray[n2];
                writer.append(Double.toString(point.getCoord_X()));
                writer.append(",");
                writer.append(Double.toString(point.getCoord_Y()));
                writer.append(",1,2,");
                boolean found = false;
                for (Cluster cluster : result) {
                    ArrayList<Coord> list = cluster.getCoordList();
                    for (Coord coord : list) {
                        Grid grid = this.steps[coord.x][coord.y];
                        ArrayList plist = grid.list;
                        if (!plist.contains(point)) continue;
                        writer.append("cluster" + cluster.clusterLabel);
                        found = true;
                    }
                }
                if (!found) {
                    writer.append("-1");
                }
                writer.newLine();
                ++n2;
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void process() {
        ArrayList<Coord> centers = this.markCandidatePoints();
        ArrayList<Cluster> clusters = this.searchCluster();
        clusters = this.refineCluster(centers, clusters);
        BufferedImage img = ImageGenerator.drawImage(null, DataBase.sLen);
        Graphics g = img.getGraphics();
        CoordTransfer tsf = new CoordTransfer();
        int i = 0;
        int len = clusters.size();
        while (i < len) {
            Cluster cluster = clusters.get(i);
            float t = (float)(cluster.clusterLabel - 1) / (float)len;
            Color color = CounterUtil.HLStoRGB(t, 0.5f, 0.5f);
            ArrayList<Coord> list = cluster.getCoordList();
            g.setColor(Color.black);
            g.setFont(new Font("SansSerif", 1, 18));
            int[] coord = tsf.getPanelCoord(cluster.xloc, cluster.yloc);
            g.drawString(Integer.toString(cluster.clusterLabel), coord[0], coord[1]);
            for (Coord c : list) {
                Grid grid = this.steps[c.x][c.y];
                ArrayList plist = grid.list;
                for (DataPoint point : plist) {
                    ImageGenerator.show_DataPoint_on_Image(img, point, color);
                }
            }
            ++i;
        }
        g.setColor(Color.black);
        g.drawString("k=" + this.K + ", ifp=" + this.IFP + ", t=" + this.thread, 20, DataBase.sLen - 40);
        g.dispose();
        g.dispose();
        DataField.updateImagePanel(img);
    }

    ArrayList<Cluster> searchCluster() {
        int clusterSize = this.labelResultMap();
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        int i = 0;
        while (i < clusterSize) {
            clusters.add(new Cluster(i + 1));
            ++i;
        }
        int y = 0;
        while (y < this.K) {
            int x = 0;
            while (x < this.K) {
                int v = this.lookupTable[x][y];
                if (v >= 1) {
                    Cluster cluster = clusters.get(v - 1);
                    cluster.addCoord(new Coord(x, y));
                    clusters.set(v - 1, cluster);
                }
                ++x;
            }
            ++y;
        }
        return clusters;
    }

    ArrayList<Cluster> refineCluster(ArrayList<Coord> centers, ArrayList<Cluster> clusters) {
        ArrayList<Cluster> result = new ArrayList<Cluster>();
        for (Cluster c : clusters) {
            ArrayList<Coord> list = c.getCoordList();
            boolean pass = false;
            for (Coord center : centers) {
                if (!list.contains(center)) continue;
                pass = true;
                break;
            }
            if (!pass) continue;
            result.add(c);
        }
        int i = 0;
        while (i < result.size()) {
            Cluster cluster = result.get(i);
            cluster.clusterLabel = i + 1;
            result.set(i, cluster);
            ++i;
        }
        return result;
    }

    private int labelResultMap() {
        int clusterLabel = 1;
        int y = 0;
        while (y < this.K) {
            int x = 0;
            while (x < this.K) {
                if (this.lookupTable[x][y] == -1) {
                    this.floodFillResultMap(x, y, clusterLabel++);
                }
                ++x;
            }
            ++y;
        }
        return --clusterLabel;
    }

    private void floodFillResultMap(int x, int y, int label) {
        LinkedList<Coord> list = new LinkedList<Coord>();
        list.addFirst(new Coord(x, y));
        while (list.size() != 0) {
            Coord c = (Coord)list.removeLast();
            if (this.lookupTable[c.x][c.y] != -1) continue;
            this.lookupTable[c.x][c.y] = label;
            if (c.x > 0) {
                list.add(new Coord(c.x - 1, c.y));
            }
            if (c.x < this.K - 1) {
                list.add(new Coord(c.x + 1, c.y));
            }
            if (c.y > 0) {
                list.add(new Coord(c.x, c.y - 1));
            }
            if (c.y >= this.K - 1) continue;
            list.add(new Coord(c.x, c.y + 1));
        }
    }

    ArrayList<Coord> markCandidatePoints() {
        this.countPotential();
        ArrayList<Coord> xlist = this.getCanPointsOnX();
        ArrayList<Coord> ylist = this.getCanPointsOnY();
        ArrayList<Coord> centers = new ArrayList<Coord>();
        this.thread = Integer.MAX_VALUE;
        for (Coord c : xlist) {
            if (!ylist.contains(c)) continue;
            if (this.steps[c.x][c.y].pnumber < this.thread) {
                this.thread = this.steps[c.x][c.y].pnumber;
            }
            centers.add(c);
        }
        ArrayList<Coord> dxlist = this.getDensityCoordsOnX(xlist);
        ArrayList<Coord> dylist = this.getDensityCoordsOnY(ylist);
        for (Coord c : dxlist) {
            if (dylist.contains(c)) continue;
            dylist.add(c);
        }
        String input = JOptionPane.showInputDialog("Please Input the Noise Thred t", (Object)Integer.toString(this.thread - 1 > 0 ? this.thread - 1 : 0));
        this.thread = Integer.parseInt(input.trim());
        for (Coord c : dylist) {
            int x = c.x;
            int y = c.y;
            if (this.steps[x][y].pnumber <= this.thread || this.lookupTable[x][y] != 0) continue;
            this.lookupTable[x][y] = -1;
        }
        return centers;
    }

    private ArrayList<Coord> getCanPointsOnX() {
        ArrayList<Coord> points = new ArrayList<Coord>();
        int y = 0;
        while (y < this.K) {
            int x = 1;
            while (x < this.K) {
                double dpx1 = this.steps[x - 1][y].getXdp();
                double dpx2 = this.steps[x][y].getXdp();
                if (dpx1 == 0.0 && dpx2 < 0.0) {
                    points.add(new Coord(x - 1, y));
                } else if (dpx1 > 0.0 && dpx2 == 0.0) {
                    points.add(new Coord(x, y));
                } else if (dpx1 > 0.0 && dpx2 < 0.0) {
                    double t = dpx1 + dpx2;
                    if (t > 0.0) {
                        points.add(new Coord(x, y));
                    } else {
                        points.add(new Coord(x - 1, y));
                    }
                }
                ++x;
            }
            ++y;
        }
        return points;
    }

    private ArrayList<Coord> getDensityCoordsOnX(ArrayList<Coord> centers) {
        int know = this.steps.length;
        ArrayList<Coord> result = new ArrayList<Coord>();
        block0: for (Coord c : centers) {
            double dpx2;
            double dpx1;
            int x = c.x;
            int y = c.y;
            result.add(c);
            while (--x >= 0) {
                dpx1 = this.steps[x][y].getXdp();
                if (dpx1 < (dpx2 = this.steps[x + 1][y].getXdp())) break;
                result.add(new Coord(x, y));
            }
            x = c.x;
            y = c.y;
            while (++x < know) {
                dpx1 = this.steps[x - 1][y].getXdp();
                if (dpx1 < (dpx2 = this.steps[x][y].getXdp())) continue block0;
                result.add(new Coord(x, y));
            }
        }
        return result;
    }

    private ArrayList<Coord> getCanPointsOnY() {
        ArrayList<Coord> points = new ArrayList<Coord>();
        int x = 0;
        while (x < this.K) {
            int y = 1;
            while (y < this.K) {
                double dpy1 = this.steps[x][y - 1].getYdp();
                double dpy2 = this.steps[x][y].getYdp();
                if (dpy1 == 0.0 && dpy2 < 0.0) {
                    points.add(new Coord(x, y - 1));
                } else if (dpy1 > 0.0 && dpy2 == 0.0) {
                    points.add(new Coord(x, y));
                } else if (dpy1 > 0.0 && dpy2 < 0.0) {
                    double t = dpy1 + dpy2;
                    if (t > 0.0) {
                        points.add(new Coord(x, y));
                    } else {
                        points.add(new Coord(x, y - 1));
                    }
                }
                ++y;
            }
            ++x;
        }
        return points;
    }

    private ArrayList<Coord> getDensityCoordsOnY(ArrayList<Coord> centers) {
        int know = this.steps.length;
        ArrayList<Coord> result = new ArrayList<Coord>();
        block0: for (Coord c : centers) {
            double dpy2;
            double dpy1;
            int x = c.x;
            int y = c.y;
            result.add(c);
            while (--y >= 0) {
                dpy1 = this.steps[x][y].getYdp();
                if (dpy1 < (dpy2 = this.steps[x][y + 1].getYdp())) break;
                result.add(new Coord(x, y));
            }
            x = c.x;
            y = c.y;
            while (++y < know) {
                dpy1 = this.steps[x][y - 1].getYdp();
                if (dpy1 < (dpy2 = this.steps[x][y].getYdp())) continue block0;
                result.add(new Coord(x, y));
            }
        }
        return result;
    }

    protected BufferedImage showCoord(BufferedImage img) {
        int[] coord;
        CoordTransfer tsf = new CoordTransfer();
        Graphics g = img.getGraphics();
        g.setColor(Color.gray);
        int[] len = tsf.getPanelCoord(this.xmin + this.dx * (double)this.K, this.ymin + this.dy * (double)this.K);
        int y = 0;
        while (y <= this.K) {
            double yloc = this.ymin + this.dy * (double)y;
            coord = tsf.getPanelCoord(this.xmin, yloc);
            g.drawLine(coord[0], coord[1], len[0], coord[1]);
            ++y;
        }
        int x = 0;
        while (x <= this.K) {
            double xloc = this.xmin + this.dx * (double)x;
            coord = tsf.getPanelCoord(xloc, this.ymin);
            g.drawLine(coord[0], coord[1], coord[0], len[1]);
            ++x;
        }
        g.dispose();
        return img;
    }

    protected BufferedImage showLargeCoord(BufferedImage img) {
        int[] coord;
        CoordTransfer tsf = new CoordTransfer();
        Graphics g = img.getGraphics();
        g.setColor(Color.black);
        int[] len = tsf.getPanelCoord(this.xmin + this.dx * (double)this.K, this.ymin + this.dy * (double)this.K);
        int y = 0;
        while (y <= this.K) {
            double yloc = this.ymin + this.dy * (double)y;
            coord = tsf.getPanelCoord(this.xmin, yloc);
            g.drawLine(coord[0], coord[1], len[0], coord[1]);
            y += this.IFP;
        }
        int x = 0;
        while (x <= this.K) {
            double xloc = this.xmin + this.dx * (double)x;
            coord = tsf.getPanelCoord(xloc, this.ymin);
            g.drawLine(coord[0], coord[1], coord[0], len[1]);
            x += this.IFP;
        }
        g.dispose();
        return img;
    }

    private void countPotential() {
        int BK = this.K / this.IFP;
        this.grids = new BigGrid[BK][BK];
        int ky = 0;
        while (ky < BK) {
            int kx = 0;
            while (kx < BK) {
                double xall = 0.0;
                double yall = 0.0;
                int pall = 0;
                double xloc = -1.0;
                double yloc = -1.0;
                int y = 0;
                while (y < this.IFP) {
                    int x = 0;
                    while (x < this.IFP) {
                        int xnum = kx * this.IFP + x;
                        int ynum = ky * this.IFP + y;
                        xall += this.steps[xnum][ynum].getXall();
                        yall += this.steps[xnum][ynum].getYall();
                        pall += this.steps[xnum][ynum].getWeight();
                        ++x;
                    }
                    ++y;
                }
                if (pall > 0) {
                    BigGrid grid;
                    this.grids[kx][ky] = grid = new BigGrid(xall / (double)pall, yall / (double)pall, pall);
                } else {
                    BigGrid grid;
                    int c = this.IFP * this.IFP;
                    this.grids[kx][ky] = grid = new BigGrid(xloc / (double)c, yloc / (double)c, pall);
                }
                ++kx;
            }
            ++ky;
        }
        double sigma2 = this.sigma * this.sigma;
        int x = 0;
        while (x < this.K) {
            int y = 0;
            while (y < this.K) {
                double xloc = this.steps[x][y].getXloc();
                double yloc = this.steps[x][y].getYloc();
                double dpx = 0.0;
                double dpy = 0.0;
                int bx = 0;
                while (bx < BK) {
                    int by = 0;
                    while (by < BK) {
                        BigGrid bg = this.grids[bx][by];
                        double dx = bg.getXloc() - xloc;
                        double dy = bg.getYloc() - yloc;
                        double dist2 = dx * dx + dy * dy;
                        double temp = (double)bg.getWeight() * Math.pow(Math.E, -dist2 / sigma2);
                        dpx += dx * temp;
                        dpy += dy * temp;
                        ++by;
                    }
                    ++bx;
                }
                this.steps[x][y].setXdp(dpx);
                this.steps[x][y].setYdp(dpy);
                ++y;
            }
            ++x;
        }
    }

    private class BigGrid {
        private double xloc = -1.0;
        private double yloc = -1.0;
        private int pnumber = 0;

        public BigGrid(double xloc, double yloc, int pnumber) {
            this.xloc = xloc;
            this.yloc = yloc;
            this.pnumber = pnumber;
        }

        public double getXloc() {
            return this.xloc;
        }

        public double getYloc() {
            return this.yloc;
        }

        public int getWeight() {
            return this.pnumber;
        }
    }

    private class Cluster {
        int clusterLabel;
        double xloc = -1.0;
        double yloc = -1.0;
        ArrayList<Coord> list;

        public Cluster(int clusterLabel) {
            this.clusterLabel = clusterLabel;
            this.list = new ArrayList();
        }

        void addCoord(Coord c) {
            if (this.xloc == -1.0) {
                this.xloc = Hasta.this.steps[c.x][c.y].getXloc();
                this.yloc = Hasta.this.steps[c.x][c.y].getYloc();
            }
            this.list.add(c);
        }

        ArrayList<Coord> getCoordList() {
            return this.list;
        }
    }

    private class Coord {
        int x;
        int y;

        public Coord(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + this.x;
            result = 31 * result + this.y;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Coord other = (Coord)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.x != other.x) {
                return false;
            }
            return this.y == other.y;
        }

        private Hasta getOuterType() {
            return Hasta.this;
        }
    }

    private class Grid {
        private double xall = 0.0;
        private double yall = 0.0;
        private double xloc = -1.0;
        private double yloc = -1.0;
        private double xdp = -1.0;
        private double ydp = -1.0;
        private int pnumber = 0;
        private ArrayList<DataPoint> list = new ArrayList();

        private Grid() {
        }

        public void add(DataPoint point) {
            ++this.pnumber;
            this.xall += point.getCoord_X();
            this.yall += point.getCoord_Y();
            this.list.add(point);
        }

        public void setCenter(double xloc, double yloc) {
            this.xloc = xloc;
            this.yloc = yloc;
        }

        public double getXall() {
            return this.xall;
        }

        public double getYall() {
            return this.yall;
        }

        public double getXloc() {
            if (this.xloc == -1.0 && this.pnumber != 0) {
                this.xloc = this.xall / (double)this.pnumber;
            }
            return this.xloc;
        }

        public double getYloc() {
            if (this.yloc == -1.0 && this.pnumber != 0) {
                this.yloc = this.yall / (double)this.pnumber;
            }
            return this.yloc;
        }

        public int getWeight() {
            return this.pnumber;
        }

        public double getXdp() {
            return this.xdp;
        }

        public void setXdp(double xdp) {
            this.xdp = xdp;
        }

        public double getYdp() {
            return this.ydp;
        }

        public void setYdp(double ydp) {
            this.ydp = ydp;
        }
    }
}

