/*
 * Decompiled with CFR 0.152.
 */
package com.ethon.ui;

import com.ethon.DataBase;
import com.ethon.io.DataReader;
import com.ethon.mode.DataPoint;
import com.ethon.plugin.Hasta;
import com.ethon.tools.CoordTransfer;
import com.ethon.tools.ImageGenerator;
import com.ethon.ui.ImagePanel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class DataField
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static ImagePanel ipanel;
    static BufferedImage tempImg;

    public DataField() {
        UIManager.LookAndFeelInfo[] info;
        String ui = UIManager.getSystemLookAndFeelClassName();
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = info = UIManager.getInstalledLookAndFeels();
        int n = info.length;
        int n2 = 0;
        while (n2 < n) {
            UIManager.LookAndFeelInfo lk = lookAndFeelInfoArray[n2];
            if (lk.getName().equals("Nimbus")) {
                ui = lk.getClassName();
                break;
            }
            ++n2;
        }
        try {
            UIManager.setLookAndFeel(ui);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        MenuBar mb = new MenuBar();
        this.setJMenuBar(mb);
        Dimension dim = this.getToolkit().getScreenSize();
        int sw = (int)dim.getWidth() / 9;
        int sh = (int)dim.getHeight() / 9;
        this.setLocation(sw, sh);
        this.setSize(sw * 7, sh * 7);
        int len = CoordTransfer.getLenOfImagePanel(this);
        tempImg = ImageGenerator.drawImage(null, len);
        ipanel = new ImagePanel(this);
        this.add(ipanel);
        this.setTitle("DataField Clustering Tool");
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
    }

    public static void updateImagePanel(BufferedImage image) {
        tempImg = image;
        ipanel.update(image);
    }

    public static BufferedImage getImage() {
        return tempImg;
    }

    public void resetDataField() {
    }

    private class ExitListener
    implements ActionListener {
        private ExitListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    }

    class FileOpenListener
    implements ActionListener {
        FileOpenListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JFileChooser jfc = new JFileChooser();
            int value = jfc.showOpenDialog(DataField.this);
            if (value == 0) {
                DataField.this.resetDataField();
                DataReader reader = new DataReader();
                File file = jfc.getSelectedFile();
                DataField.this.setTitle("DataField Clustering Tool--" + file.getName());
                DataBase.getInstance().clear();
                DataPoint[] points = reader.getDataPoints(file, 0);
                CoordTransfer ctf = new CoordTransfer();
                int len = CoordTransfer.getLenOfImagePanel(DataField.this);
                ctf.initCoord(points, len);
                BufferedImage image = ImageGenerator.drawImage(null, len);
                image = ImageGenerator.show_DataPoints_on_Image(points, image);
                DataField.updateImagePanel(image);
            }
        }
    }

    class MenuBar
    extends JMenuBar {
        private static final long serialVersionUID = 1L;

        MenuBar() {
            JMenu menu1 = new JMenu("File");
            JMenuItem item11 = new JMenuItem("Open");
            item11.addActionListener(new FileOpenListener());
            JMenuItem item12 = new JMenuItem("Exit");
            item12.addActionListener(new ExitListener());
            JMenu menu2 = new JMenu("Clustering");
            JMenuItem item23 = new JMenuItem("Hasta Clustering Algorithm");
            item23.addActionListener(new SECSNClusterListener());
            menu1.add(item11);
            menu1.add(item12);
            menu2.add(item23);
            this.add(menu1);
            this.add(menu2);
        }
    }

    class SECSNClusterListener
    implements ActionListener {
        SECSNClusterListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            String input = JOptionPane.showInputDialog("Please input the Grid-number Parameter k");
            if (input == null) {
                return;
            }
            int K = Integer.parseInt(input.trim());
            input = JOptionPane.showInputDialog("Please input the Impact-factor Parameter ifp");
            if (input == null) {
                return;
            }
            int stepParam = Integer.parseInt(input.trim());
            Hasta nm = new Hasta(K, stepParam);
            nm.process();
        }
    }
}

