/*
 * Decompiled with CFR 0.152.
 */
package com.ethon.ui;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class IntTextField
extends JTextField {
    private static final long serialVersionUID = 1L;
    private int min;

    public IntTextField(int min) {
        this.min = min;
        this.setDocument(new IntDocument());
    }

    class IntDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;

        IntDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (this.isNumber(str)) {
                String before = IntTextField.this.getText();
                String after = String.valueOf(before.substring(0, offs)) + str + before.substring(offs);
                if (!after.matches("[0-9]*")) {
                    return;
                }
                Integer value = Integer.parseInt(after);
                if (value < IntTextField.this.min) {
                    return;
                }
                super.insertString(offs, str, a);
            }
        }

        boolean isNumber(String str) {
            if (str == null || str.trim().length() == 0) {
                return false;
            }
            int i = 0;
            while (i < str.length()) {
                char a = str.charAt(i);
                if (a >= '0' && a <= '9') {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

