/* file do_fits.h
   Header for FITS i/o.  */

#define _GNU_SOURCE
#define _ISOC99_SOURCE        /* For NAN, etc */
#define _FILE_OFFSET_BITS 64  /* For type off_t (64-bit lseek) */

#include <math.h>
#include <stdlib.h>
#include <stdio.h>

#define AXSLACK                             10   /* Slack for nax, dax, cdax */
#define BSIZE                             2880
#define LINE_LENGTH                         80
#define NUM_LINES                           36   /* = BSIZE/LINE_LENGTH */
#define HEAD_EXCESS                          1
#define INDENT                              10
#define DYNAM_RANGE_BYTE                   255
#define DYNAM_RANGE_SHORT                32767
#define DYNAM_RANGE_INT             2147483647
#define DYNAM_RANGE_LL     9223372036854775807LL
#define STD_BLOCK_SIZE               4096*4096 

#define MAX_SIG_FIGS                        30
#define MAX_DAT_SIZE                         8   /* bytes */
#define CUM_DAT_SIZE                        15   /* bytes */
#define DATA_RANGE                           0
#define HEAD_RANGE                           1
#define NOT_FITS_HEAD                       -2
#define NOT_VALID_VALUE                     -2
#define NOT_VALID_FORMAT                    -3

#define ERROR_FRAC_LIMIT                     0.001

#define nx                              nax[0]
#define ny                              nax[1]
#define nz                              nax[2]
#define nw                              nax[3]

#define dx                              dax[0]
#define dy                              dax[1]
#define dz                              dax[2]
#define dw                              dax[3]

#define cdx                             cdax[0]
#define cdy                             cdax[1]
#define cdz                             cdax[2]
#define cdw                             cdax[3]

int             bitpix, dat_size, ref_min_set, ref_max_set;
int             num_head_recs, fits_excess;
char            io_buff[BSIZE], *inhead, *current_head, *text_buff;
unsigned char   *dat_byte;
short           *dat_short;
long            *dat_long;
int             *dat_int;
long long       *dat_ll;
float           *dat_flt;
double          *dat_dbl;
double          df_datbuff[STD_BLOCK_SIZE];
unsigned int    byte_map[CUM_DAT_SIZE], rev_byte_map[CUM_DAT_SIZE];
double          sig_min, sig_max, ref_min, ref_max, b_zero, b_scale;
int             *nax;
double          *dax;
double          *cdax;
int             naxis;
off_t           num_pts;
char            *dfprogname;

int init_fits(char pname[]);
int map_bytes(unsigned int map[], char buff[], int num_words);
int set_scale(double min, double max);
int pad_file(int fid);
int init_buff(char buff[], char c, int n);
int get_head(int fid, char **pbuff);
int count_head_lines(char buff[]);
int get_keyword_value(
    char head[], 
    char keyword[], 
    char format[], 
    ...);
int get_keyword_comment(
    char head[],
    char keyword[],
    char comment[]);
int put_keyword_value(
    char      head[], 
    int       location, 
    char      keyword[], 
    char      format[], 
    ...);
int find_keyword(char head[], char keyword[]);
    int revise_keyword_value(
    char head[], 
    char keyword[], 
    char format[], 
    ...);
int revise_keyword(
    char head[], 
    char keyword[], 
    char new_keyword[]);
    int insert_keyword_value(
    char head[], 
    long     location, 
    char keyword[], 
    char format[], 
    ...);
int delete_keyword(char head[], char keyword[]);
int read_head(char buff[]);
int make_head(char **pbuff);
int update_head(char head[]);
int put_head(int fid, char buff[]);
int read_fits(int fid, double **pdat_fp);
int write_fits(int fid, double dat_fp[]);
int put_line(char line[], char buff[]);
long long inint(double x);
int input_data(int fid, double data_fp[], int n);
int output_data(int fid, double data_fp[], int n);
int min_max(double data[], int n);
int nom_ord_range(int fid, int mode);
int get_text(FILE *fp, char **pbuff);
int head_to_text(char head[], char **ptext);
int text_to_head(char text[], char **phead);
int print_head(char head[]);
int block_size(int n, int count);
int copy_head(char head[], char **pnewhead, int num_extra_recs);
int seg_cmp(char line1[], char line2[], int n);
int seg_copy(char line1[], char line2[], int n);
int seg_len(char line[]);
int compare_fp_values(double x, double y);
int extend_data(int fid, int start, int extension);
