/* Program pie_mask
 * This program outputs a fits image that consists of a simple circular mask.
 * The interior of the specified circle is given a value of 1.0.  The 
 * exterior is given a value of 0.0.  Compile this program with the command
 * 
 *                  "gcc -O3 rect_mask.c -o rect_mask".
 */

#define _FILE_OFFSET_BITS 64

#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "do_fits.h"

struct int_pair {int x; int y;};

int make_mask(double dat_buff[], double x0, double y0, double theta1, double theta2);

static double pi = 3.14159265359;

int main(int argc, char *argv[])
{
    int i, fid;
    double *dat_buff, x1, y1, x2, y2;
    double atof();

    init_fits(argv[0]);

    if (argc != 7)
    {
        printf("\nUsage:  %s ref_frame x1 y1 ", argv[0]);
        printf("x2 y2 output_image\n\n");
        exit(0);
    }

    if ((fid = open(argv[1], O_RDONLY)) == EOF)
    {
        printf("%s:  Cannot open file named %s.  Exiting.\n", 
            argv[0], argv[1]);
        exit(0); 
    }
    read_fits(fid, &dat_buff);
    close (fid);
    if (naxis != 2)
    {
        printf("%s:  This program expects reference file %s to be a 2-D ",
            argv[0], argv[1]);
        printf("image; it is %d-D.\nExiting.\n", naxis);
        exit(0);
    }

    x1 = atof(argv[2]);
    y1 = atof(argv[3]);
    x2 = atof(argv[4]);
    y2 = atof(argv[5]);

    if (x1 > x2)
    {
        printf("%s:  Argument x2 must be at least x1.  Exiting\n", 
            argv[0]);
        exit(0);
    }

    if (y1 > y2)
    {
        printf("%s:  Argument y2 must be at least y1.  Exiting\n", 
            argv[0]);
        exit(0);
    }

    make_mask(dat_buff, x1, y1, x2, y2);

    if ((fid = open(argv[6], O_WRONLY | O_EXCL | O_CREAT, 0644)) == EOF)
    {
        printf("%s:  File named %s already exists.  Exiting.\n", 
            argv[0], argv[6]);
        exit(0);
    }

    current_head = inhead;
    insert_keyword_value(current_head, 0, "X1",     "%le", x1,     "");
    insert_keyword_value(current_head, 0, "Y1",     "%le", y1,     "");
    insert_keyword_value(current_head, 0, "X2",     "%le", x2,     "");
    insert_keyword_value(current_head, 0, "Y2",     "%le", y2,     "");
    write_fits(fid, dat_buff);

    close (fid);  
    free(dat_buff);
}

int make_mask(double dat_buff[], double x1, double y1, double x2, double y2)
{
    int    i, j;
    double **dat, x, y, theta;
 
    dat  = (double **)malloc(ny*sizeof(double *));

    for (i = 0; i < ny; i++)
        dat[i]  = dat_buff  + nx*i;

    for (i = 0; i < ny; i++)
        for (j = 0; j < nx; j++)
            if (i >= y1 && i <= y2 && j >= x1 && j <= x2)
                dat[i][j] = 1.;
            else
                dat[i][j] = 0.;

    free(dat);

    return 1;
}
