/* Program  blank_frame
 * Produces a fits file for a two-dimensional array with specified 
 * dimensions and specified constant pixel value.  
 * Compile the program with the command 
 *
 *                "gcc -O3 blank_frame.c -o blank_frame".
 */

#define _FILE_OFFSET_BITS 64

#include <math.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "do_fits.h"

void print_diag(int argc, char *argv[]);
int  open_file(char file_name[], char mode[]);
int  fill_frame(double frame_value, double **pdat);

int main(int argc, char *argv[])
{
    int i, fid;
    double frame_value, *dat;
    double atof();

    init_fits(argv[0]);

    print_diag(argc, argv);

    naxis = argc - 3;
    nax  = (int    *)malloc(naxis*sizeof(int   ));
    dax  = (double *)malloc(naxis*sizeof(double));
    cdax = (double *)malloc(naxis*sizeof(double));
    for (i = 0, num_pts = 1; i < naxis; i++)
    {
        num_pts *= (nax[i] = atoi(argv[i + 1])); 
        dax[i]  = 1.0;
        cdax[i] = 1.0;
    }

    if (strncmp(argv[argc - 2], "NAN", 3) == 0
    ||  strncmp(argv[argc - 2], "nan", 3) == 0
    ||  strncmp(argv[argc - 2], "NaN", 3) == 0)
        frame_value = NAN;
    else
        frame_value = atof(argv[argc - 2]);

    fill_frame(frame_value, &dat);

    bitpix = 16;
    fid = open_file(argv[argc - 1], "w");
    write_fits(fid, dat);

    close (fid);
    free(nax);
    free(dax);
}

void print_diag(int argc, char *argv[])
{
    if (argc < 5)
    {
        printf("Usage:  %s nx [ ny ... ] frame_value output_filename\n", 
            argv[0]);
        exit(0);
    }
}

int open_file(char file_name[], char mode[])
{
    int fid;

    if (seg_cmp(mode, "r", 1) == 0)
    {
        if ((fid = open(file_name, O_RDONLY)) == EOF)
        {
            printf("Cannot open file named %s.  Exiting.\n", file_name);
            exit(0);
        }
        return fid;
    }

    if (seg_cmp(mode, "w", 1) == 0)
    {
        if ((fid = open(file_name, O_EXCL | O_CREAT, 0644)) == EOF)
        {
            printf("File named %s already exists.  Overwrite?  ", file_name);
            if (getchar() != 'y')
                exit(0);
        }
        else
            close (fid);
        fid = open(file_name, O_WRONLY | O_TRUNC);
        return fid;
    }
    return 0;
}

int fill_frame(double frame_value, double **pdat)
{
    int i;

    *pdat = (double *)malloc(num_pts*sizeof(double));
    for (i = 0; i < num_pts; i++)
        (*pdat)[i] = frame_value;

    return 1;
}
