/* Program list_z_profile
 * This program prints statistics of pixel values in a fits file.
 * Compile this program with the command
 *
 *       "gcc -O3 list_z_profile.c -o list_z_profile -lm".
 */

#define _FILE_OFFSET_BITS 64

#include <math.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include "do_fits.h"

int calc_stats(double dat_in[], double mask[]);

int    naxis1, *nax1, naxis2, *nax2;
int    num_pix;
double ave, ms;
off_t  ppf;

int main(int argc, char *argv[])
{
    char   out_file[LINE_LENGTH + 1];
    int    i, j, k, l, fid1, fid2, stat;
    int    bitpix1, dat_size1, nf_data, nc_data;
    int    bitpix2, dat_size2, nf_mask;
    double b_scale1, b_zero1;
    double b_scale2, b_zero2;
    double *dat_buff, *mask_buff;
    double z1;
    double rms;
    off_t  dat_start1, dat_start2, bpf1, bpf2;

    init_fits(argv[0]);

    if (argc != 2 && argc != 3)
    {
        printf("Usage:  %s filename [mask]\n", argv[0]);
        exit(0);
    }

    if (argc == 3)
    {
        if ((fid2 = open(argv[2], O_RDONLY)) == EOF)
        {
            printf("%s:  Cannot open file %s.  Exiting.\n", argv[0], argv[2]);
            exit(0);
        }
        if (get_head(fid2, &inhead) == EOF)
        {
            printf("%s:  Defective fits head in file %s.  Exiting.\n",
            argv[0], argv[2]);
            exit(0);
        }
        if (read_head(inhead) == EOF)
        {
            printf("%s:  Cannot read fits head in file %s.  Exiting.\n",
            argv[0], argv[2]);
            exit(0);
        }

        naxis2     = naxis;
        nax2       = nax;
        bitpix2    = bitpix;
        if (bitpix > 0)
        {
            b_scale2   = b_scale;
            b_zero2    = b_zero;
        }
        dat_start2 = lseek(fid2, 0, SEEK_CUR);
    }
    else
        naxis2    = 0;

    if ((fid1 = open(argv[1], O_RDONLY)) == EOF)
    {
        printf("%s:  Cannot open file %s.  Exiting.\n", argv[0], argv[1]);
        exit(0);
    }
    if (get_head(fid1, &inhead) == EOF)
    {
        printf("%s:  Defective fits head in file %s.  Exiting.\n",
        argv[0], argv[1]);
        exit(0);
    }
    if (read_head(inhead) == EOF)
    {
        printf("%s:  Cannot read fits head in file %s.  Exiting.\n",
        argv[0], argv[1]);
        exit(0);
    }

    if (get_keyword_value(inhead, "Z1", "%le", &z1) == EOF)
        z1 = 0.;

    naxis1     = naxis;
    nax1       = nax;
    bitpix1    = bitpix;
    if (bitpix > 0)
    {
        b_scale1   =  b_scale;
        b_zero1    =  b_zero;
        dat_size1  =  bitpix/8;
    }
    else
        dat_size1  = -bitpix/8;
    dat_start1 = lseek(fid1, 0, SEEK_CUR);

    if (naxis1 < 3)
    {
        printf("%s:  file %s must be at least 3 dimensions.  Exiting.\n", 
            argv[0], argv[1]);
        exit(0);
    }

    if (naxis2 != 0 && naxis2 < 2)
    {
        printf("%s:  Mask file %s must be at least 2 dimensions.  Exiting.\n", 
            argv[0], argv[2]);
        exit(0);
    }

    for (i = 0, ppf = 1, nf_data = 1, nf_mask = 1; i < naxis1; i++)
    {
        if (i < naxis2 && nax2[i] != nax1[i])
        {
            printf("%s:  Mask wrong dimensions.  Exiting.\n", argv[0]);
            exit(0);
        }

        if (i < 2)
            ppf *= nax1[i];
        else
        { 
            /*  if (i < naxis1)  */
            nf_data *= nax1[i]; /* becomes # of 2-D frames in datacube. */
            if (i < naxis2)
                nf_mask *= nax1[i]; /* becomes # of 2-D frames in mask. */
        }
    }
    nc_data    = nf_data/nz;
    if (bitpix1 > 0)
        dat_size1  =  bitpix1/8;
    else
        dat_size1  = -bitpix1/8;
    if (bitpix2 > 0)
        dat_size2  =  bitpix2/8;
    else
        dat_size2  = -bitpix2/8;
    bpf1       = dat_size1*ppf;
    bpf2       = dat_size2*ppf;
    dat_buff   = (double *)malloc(ppf*sizeof(double));
    if (naxis2 > 0)
        mask_buff  = (double *)malloc(ppf*sizeof(double));
    else
        mask_buff  = NULL;

    for (i = 0; i < nz; i++)
    {
        printf("%16.8e", z1 + i*dz);
        for (j = 0; j < nc_data; j++)
        {
            k = j*nz + i;
            l = k%nf_mask;
            lseek(fid1, k*bpf1 + dat_start1, SEEK_SET);
            bitpix   = bitpix1;
            if (bitpix > 0)
            {
                b_scale  = b_scale1;
                b_zero   = b_zero1 ;
            }
            dat_size = dat_size1;
            input_data(fid1, dat_buff, ppf);

            if (naxis2 > 0)
            {
                bitpix   = bitpix2;
                if (bitpix > 0)
                {
                    b_scale  = b_scale2;
                    b_zero   = b_zero2;
                }
                dat_size = dat_size2;
                lseek(fid2, l*bpf2 + dat_start2, SEEK_SET);
                input_data(fid2, mask_buff, ppf);
            }

            stat = calc_stats(dat_buff, mask_buff);

            ave   /= (double)num_pix;
            ms    /= (double)num_pix;
            rms    = ms - ave*ave;

            if (rms <= 0.)
                rms = 0.;
            else
                rms = sqrt(rms);

            printf("  %16.8e %16.8e", ave, rms);
        }
        printf("\n");
    }

    close (fid1);
    close (fid2);

    free(dat_buff);
    free(nax1);
    if (argc == 3)
    {
        free(mask_buff);
        free(nax2);
    }
}

int calc_stats(double dat_in[], double mask[])
{
    int i;
    double diff;

    if (mask == NULL)
    {
        num_pix = 0;
        ave     = 0.;
        ms      = 0.;

        for (i = 0; i < ppf; i++)
        {
            ave += dat_in[i];
            ms  += dat_in[i]*dat_in[i];
            num_pix++;
        }
    }
    else
    {
        num_pix = 0;
        ave     = 0.;
        ms      = 0.;

        for (i = 0; i < ppf; i++)
            if (mask[i] > 0.)
            {
                ave += dat_in[i];
                ms  += dat_in[i]*dat_in[i];
                num_pix++;
            }
    }

    return num_pix;
}
