/****************************************************************************

 File:    allcmdtrees.cpp
 Created: by Aidan Lane, January  27, 2004
 Updated: by Aidan Lane, February 13, 2004
 
 This file is part of Glitch
 Copyright (C) 2003-2004  Monash University, Clayton Campus, Australia
 Created by Aidan Lane, under the supervision of Jon McCormack.
 
 This program was developed to aid the students studying the CSE3313
 Computer Graphics course at Monash University.
 
 This software may contain portions that are copyright (C) 1993,
 Silicon Graphics, Inc. All Rights Reserved.
 
 Glitch is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, version 2.
 
 Glitch is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*****************************************************************************/

#include "allcmdtrees.h"

#include "attribstree.h"
#include "colourtree.h"
#include "cameratree.h"
#include "disptree.h"
#include "displisttree.h"
#include "fogtree.h"
#include "gluttree.h"
#include "inittree.h"
#include "lighttree.h"
#include "materialtree.h"
#include "matrixtree.h"
#include "primitstree.h"
#include "projectiontree.h"
#include "transtree.h"


AllCmdTrees::AllCmdTrees()
{
	append( new AttribsTree );
	append( new ColourTree );
	append( new CameraTree );
	append( new DispTree );
	append( new DispListTree );
	append( new FogTree );
	append( new GlutTree );
	append( new InitTree );
	append( new LightTree );
	append( new MaterialTree );
	append( new MatrixTree );
	append( new PrimitsTree );
	append( new ProjectionTree );
	append( new TransTree );
}
