/****************************************************************************

 File:    glscene.h
 Created: by Aidan Lane, January  26, 2003
 Updated: by Aidan Lane, February 19, 2004
 
 This file is part of Glitch
 Copyright (C) 2003-2004  Monash University, Clayton Campus, Australia
 Created by Aidan Lane, under the supervision of Jon McCormack.
 
 This program was developed to aid the students studying the CSE3313
 Computer Graphics course at Monash University.
 
 This software may contain portions that are copyright (C) 1993,
 Silicon Graphics, Inc. All Rights Reserved.
 
 Glitch is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, version 2.
 
 Glitch is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*****************************************************************************/

#ifndef __GLSCENE_H__
#define __GLSCENE_H__


#include "cmdinstance.h"


/*! \brief Encapsulates an OpenGL scene.
 *
 * A single scene instance is designed to be shared upon multiple viewers,
 * such as GLWorldViewer and GLScreenViewer.
 *
 * The scene is drawn using a list of initialzation commmands and a list of
 * display commands, both of which need to be executed.
 *
 * It also provides a facility for stepping through commands - like a debug mode.
 */

class GLScene
{
public:
	GLScene();

	void setInitCmds( QPtrList<CmdInstance>* cmds ) { initCmds = cmds; }
	void setDisplayCmds( QPtrList<CmdInstance>* cmds ) { displayCmds = cmds; }

	void execInitCmds( bool disableProjectionMods = false,
	                   bool disableViewports = false,
	                   bool origStateAsIdentity = false) const;
	void execDisplayCmds( bool disableProjectionMods = false,
	                      bool disableViewports = false,
	                      bool origStateAsIdentity = false) const;

	// The following are used for stepping through commands - like a debug mode
	// This is the number of the end/last display command to process.
	// Note: the last command processed will be |displayCmds|-1
	//       if stepModePos> |displayCmds|-1
	void setStepModeEnabled( bool enable ) { stepMode = enable; }
	bool stepModeIsEnabled() const { return stepMode; }
	void setStepModePos( uint pos ) { stepModePos = pos; }
	uint getStepModePos() const { return stepModePos; }

	bool autoGLEndEnabled() const { return autoGLEnd; }
	void setAutoGLEndEnabled( bool enable );

private:
	void execCmdIntanceList( QPtrList<CmdInstance>* cmdInstances,
		bool useStepper, bool origStateAsIdentity,
		bool disableProjectionMods, bool disableViewports ) const;

	QPtrList<CmdInstance>* initCmds;
	QPtrList<CmdInstance>* displayCmds;

	bool stepMode;
	uint stepModePos;	// the number of the end/last display command to process

	bool autoGLEnd;
};


#endif // __GLSCENE_H__
